#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 darcs
version:              2.18.5
visibility:           public
id:                   darcs-2.18.5-8hvTX8GtlMG6n5BQW34c0g
key:                  darcs-2.18.5-8hvTX8GtlMG6n5BQW34c0g
license:              GPL-2.0-or-later
maintainer:           <darcs-devel@darcs.net>
author:               David Roundy <droundy@darcs.net>, <darcs-devel@darcs.net>
stability:            Experimental
homepage:             http://darcs.net/
synopsis:             a distributed, interactive, smart revision control system
description:
    Darcs is a free, open source revision control
    system. It is:

    * Distributed: Darcs was one of the first revision control
    systems in which every user has access to the full command
    set, removing boundaries between server and client or
    committer and non-committers.

    * Interactive: Darcs is easy to learn and efficient to use
    because it asks you questions in response to simple
    commands, giving you choices in your work flow. You can
    choose to record one change in a file, while ignoring
    another. As you update from upstream, you can review each
    patch, picking and choosing which patches are appropriate.

    * Smart: Darcs is different from most revision control
    systems in that it is based on the notion of change (or
    patch), rather than version. An underlying algebra of
    patches determines whether changes can be re-ordered. The
    laws of this algebra guarantee that the result of merging
    depends only on the final set of patches applied in a
    repository and not on their order.

    * Simple: As a consequence, Darcs offers a conceptually
    simpler view of the state of a repository: it is given by
    the set of patches it contains. Pulling and pushing
    patches merely transfers them from one set to another. So
    called "cherry-picking" is the default mode of operation,
    and it fully preserves the identity of patches.

category:             Development
abi:                  916cfb54278b815cfee7b6013500de2a
exposed:              True
exposed-modules:
    Darcs.Patch Darcs.Patch.Annotate Darcs.Patch.Annotate.Class
    Darcs.Patch.Apply Darcs.Patch.ApplyMonad Darcs.Patch.Bracketed
    Darcs.Patch.Bundle Darcs.Patch.Choices Darcs.Patch.Commute
    Darcs.Patch.CommuteFn Darcs.Patch.CommuteNoConflicts
    Darcs.Patch.Conflict Darcs.Patch.Debug Darcs.Patch.Depends
    Darcs.Patch.Effect Darcs.Patch.FileHunk Darcs.Patch.Format
    Darcs.Patch.FromPrim Darcs.Patch.Ident Darcs.Patch.Index.Monad
    Darcs.Patch.Index.Types Darcs.Patch.Info Darcs.Patch.Inspect
    Darcs.Patch.Invert Darcs.Patch.Invertible Darcs.Patch.Match
    Darcs.Patch.Merge Darcs.Patch.Named Darcs.Patch.Object
    Darcs.Patch.PatchInfoAnd Darcs.Patch.Permutations Darcs.Patch.Prim
    Darcs.Patch.Prim.Canonize Darcs.Patch.Prim.Class
    Darcs.Patch.Prim.Coalesce Darcs.Patch.Prim.FileUUID
    Darcs.Patch.Prim.FileUUID.Apply Darcs.Patch.Prim.FileUUID.Coalesce
    Darcs.Patch.Prim.FileUUID.Commute Darcs.Patch.Prim.FileUUID.Core
    Darcs.Patch.Prim.FileUUID.Details
    Darcs.Patch.Prim.FileUUID.ObjectMap Darcs.Patch.Prim.FileUUID.Read
    Darcs.Patch.Prim.FileUUID.Show Darcs.Patch.Prim.Named
    Darcs.Patch.Prim.V1 Darcs.Patch.Prim.V1.Apply
    Darcs.Patch.Prim.V1.Coalesce Darcs.Patch.Prim.V1.Commute
    Darcs.Patch.Prim.V1.Core Darcs.Patch.Prim.V1.Details
    Darcs.Patch.Prim.V1.Mangle Darcs.Patch.Prim.V1.Read
    Darcs.Patch.Prim.V1.Show Darcs.Patch.Prim.WithName
    Darcs.Patch.Progress Darcs.Patch.Read Darcs.Patch.Rebase.Change
    Darcs.Patch.Rebase.Fixup Darcs.Patch.Rebase.Legacy.Item
    Darcs.Patch.Rebase.Legacy.Wrapped Darcs.Patch.Rebase.Name
    Darcs.Patch.Rebase.PushFixup Darcs.Patch.Rebase.Suspended
    Darcs.Patch.RegChars Darcs.Patch.Repair Darcs.Patch.RepoPatch
    Darcs.Patch.Set Darcs.Patch.Show Darcs.Patch.Split
    Darcs.Patch.Summary Darcs.Patch.SummaryData
    Darcs.Patch.TokenReplace Darcs.Patch.TouchesFiles
    Darcs.Patch.Unwind Darcs.Patch.V1 Darcs.Patch.V1.Apply
    Darcs.Patch.V1.Commute Darcs.Patch.V1.Core Darcs.Patch.V1.Prim
    Darcs.Patch.V1.Read Darcs.Patch.V1.Show Darcs.Patch.V1.Viewing
    Darcs.Patch.V2 Darcs.Patch.V2.Non Darcs.Patch.V2.Prim
    Darcs.Patch.V2.RepoPatch Darcs.Patch.V3 Darcs.Patch.V3.Contexted
    Darcs.Patch.V3.Core Darcs.Patch.V3.Resolution Darcs.Patch.Viewing
    Darcs.Patch.Witnesses.Eq Darcs.Patch.Witnesses.Maybe
    Darcs.Patch.Witnesses.Ordered Darcs.Patch.Witnesses.Sealed
    Darcs.Patch.Witnesses.Show Darcs.Patch.Witnesses.Unsafe
    Darcs.Patch.Witnesses.WZipper Darcs.Prelude Darcs.Repository
    Darcs.Repository.ApplyPatches Darcs.Repository.Clone
    Darcs.Repository.Create Darcs.Repository.Diff
    Darcs.Repository.Flags Darcs.Repository.Format
    Darcs.Repository.Hashed Darcs.Repository.Identify
    Darcs.Repository.InternalTypes Darcs.Repository.Inventory
    Darcs.Repository.Inventory.Format Darcs.Repository.Job
    Darcs.Repository.Match Darcs.Repository.Merge Darcs.Repository.Old
    Darcs.Repository.Packs Darcs.Repository.PatchIndex
    Darcs.Repository.Paths Darcs.Repository.Pending
    Darcs.Repository.Prefs Darcs.Repository.Pristine
    Darcs.Repository.Rebase Darcs.Repository.Repair
    Darcs.Repository.Resolution Darcs.Repository.State
    Darcs.Repository.Transaction Darcs.Repository.Traverse
    Darcs.Repository.Unrevert Darcs.Repository.Working
    Darcs.Test.TestOnly Darcs.UI.ApplyPatches Darcs.UI.Commands
    Darcs.UI.Commands.Add Darcs.UI.Commands.Amend
    Darcs.UI.Commands.Annotate Darcs.UI.Commands.Apply
    Darcs.UI.Commands.Clone Darcs.UI.Commands.Convert
    Darcs.UI.Commands.Convert.Darcs2 Darcs.UI.Commands.Convert.Export
    Darcs.UI.Commands.Convert.Import Darcs.UI.Commands.Convert.Util
    Darcs.UI.Commands.Diff Darcs.UI.Commands.Dist
    Darcs.UI.Commands.GZCRCs Darcs.UI.Commands.Help
    Darcs.UI.Commands.Init Darcs.UI.Commands.Log
    Darcs.UI.Commands.MarkConflicts Darcs.UI.Commands.Move
    Darcs.UI.Commands.Optimize Darcs.UI.Commands.Pull
    Darcs.UI.Commands.Push Darcs.UI.Commands.Rebase
    Darcs.UI.Commands.Record Darcs.UI.Commands.Remove
    Darcs.UI.Commands.Repair Darcs.UI.Commands.Replace
    Darcs.UI.Commands.Revert Darcs.UI.Commands.Rollback
    Darcs.UI.Commands.Send Darcs.UI.Commands.SetPref
    Darcs.UI.Commands.Show Darcs.UI.Commands.ShowAuthors
    Darcs.UI.Commands.ShowContents Darcs.UI.Commands.ShowDependencies
    Darcs.UI.Commands.ShowFiles Darcs.UI.Commands.ShowIndex
    Darcs.UI.Commands.ShowPatchIndex Darcs.UI.Commands.ShowRepo
    Darcs.UI.Commands.ShowTags Darcs.UI.Commands.Tag
    Darcs.UI.Commands.Test Darcs.UI.Commands.Test.Impl
    Darcs.UI.Commands.TransferMode Darcs.UI.Commands.Unrecord
    Darcs.UI.Commands.Unrevert Darcs.UI.Commands.Util
    Darcs.UI.Commands.WhatsNew Darcs.UI.Completion Darcs.UI.Defaults
    Darcs.UI.Email Darcs.UI.External Darcs.UI.Flags Darcs.UI.Options
    Darcs.UI.Options.All Darcs.UI.Options.Core Darcs.UI.Options.Flags
    Darcs.UI.Options.Iso Darcs.UI.Options.Markdown
    Darcs.UI.Options.Matching Darcs.UI.Options.Util
    Darcs.UI.PatchHeader Darcs.UI.PrintPatch Darcs.UI.Prompt
    Darcs.UI.RunCommand Darcs.UI.RunHook Darcs.UI.SelectChanges
    Darcs.UI.TestChanges Darcs.UI.TheCommands Darcs.UI.Usage
    Darcs.Util.AtExit Darcs.Util.ByteString Darcs.Util.Cache
    Darcs.Util.CommandLine Darcs.Util.Compat Darcs.Util.DateMatcher
    Darcs.Util.DateTime Darcs.Util.Diff Darcs.Util.Diff.Myers
    Darcs.Util.Diff.Patience Darcs.Util.Encoding Darcs.Util.English
    Darcs.Util.Exception Darcs.Util.Exec Darcs.Util.File
    Darcs.Util.Global Darcs.Util.Graph Darcs.Util.HTTP Darcs.Util.Hash
    Darcs.Util.Index Darcs.Util.IndexedMonad Darcs.Util.IsoDate
    Darcs.Util.Lock Darcs.Util.Parser Darcs.Util.Path
    Darcs.Util.Printer Darcs.Util.Printer.Color Darcs.Util.Progress
    Darcs.Util.Prompt Darcs.Util.Ratified Darcs.Util.Regex
    Darcs.Util.Show Darcs.Util.SignalHandler Darcs.Util.Ssh
    Darcs.Util.StrictIdentity Darcs.Util.Tree Darcs.Util.Tree.Hashed
    Darcs.Util.Tree.Monad Darcs.Util.Tree.Plain Darcs.Util.URL
    Darcs.Util.ValidHash Darcs.Util.Workaround

hidden-modules:       Version
import-dirs:          /usr/lib/ghc-9.4.8/site-local/darcs-2.18.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/darcs-2.18.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/darcs-2.18.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/darcs
hs-libraries:         HSdarcs-2.18.5-8hvTX8GtlMG6n5BQW34c0g
depends:
    array-0.5.4.0 async-2.2.5-IlWxKJCaUbFHok4DWrcmNB
    attoparsec-0.14.4-Ie40PJLLZWYz4b9BsvrTL base-4.17.2.1
    base16-bytestring-1.0.2.0-5vlLRlPqKexCB3C79nTCDd binary-0.8.9.1
    bytestring-0.11.5.3 conduit-1.3.6.1-CCtPFpNy3fRKBOD4qyidjk
    constraints-0.13.4-3IkAD0eDg5kEkzChMdUaha containers-0.6.7
    crypton-connection-0.4.2-DmdICzf3F3qCWtTWVGaQ9N
    cryptonite-0.30-K7TqnUPLscn6NpIPT6vY8f
    data-default-0.7.1.2-7c115eFpvxq7Z5z0er1qPt
    data-ordlist-0.4.7.0-4hH2NjRHl6QGJGwQ9bkbTA directory-1.3.7.1
    exceptions-0.10.5 fgl-5.8.3.0-H444J0Zvs9qEd8XHxbmaaJ
    filepath-1.4.2.2 hashable-1.4.4.0-FG1b1gw3lrmKPDYe5KupbE
    haskeline-0.8.2 html-1.0.1.2-J6DAJfvF1D3ECsZlmS8hoI
    http-client-tls-0.3.6.4-692MveemGYY98CzdRZjDd3
    http-conduit-2.3.9.1-IVLADxofj61LH4S79M3pZR
    http-types-0.12.4-1P1R4JUxLuAK31ciTRSGza
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    mmap-0.5.9-Elwtwd4pUdW5gAqAC4PwUa mtl-2.2.2
    network-3.1.4.0-F6j0uAI5udHBrXI4nYArv7
    network-uri-2.6.4.2-L8nDuI5zE9yEZ3pwnnu7AU
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9 parsec-3.1.16.1
    process-1.6.18.0 regex-applicative-0.3.4-5oHix0Y9pFC7I64F0YvNEH
    regex-base-0.94.0.3-4CB0YhYwj75B1BjBDOnQyh
    regex-tdfa-1.3.2.4-A7DMPbd3mJ1EMZDc0SwwC7
    safe-0.3.21-60nVbSvEeiB1LI9CXyKW1J stm-2.5.1.0
    tar-0.5.1.1-HjkjPnYqDqc9KkBJn3FmUe
    temporary-1.3-r6dyYReZ4U5F588bXwn5f
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A terminfo-0.4.1.5
    text-2.0.2 time-1.12.2 tls-2.0.6-HR9OH3pYQtJJKiSQ8PkTsN
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.4-6EcuQ5mZqgo5NszRPIcG1
    utf8-string-1.0.2-4puy9i6JhHg6bynwSjfiUA
    vector-0.13.2.0-3KdUWUHYfVjDmpelwHDbn6
    zip-archive-0.4.3.2-Jj5rz1Yj5rFGO20aWVuPUI
    zlib-0.7.0.0-2L6cf4JxwJ39BT8yAGAP2z

haddock-interfaces:   /usr/share/doc/darcs/html/darcs.haddock
haddock-html:         /usr/share/doc/darcs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

