// Copyright (c) Microsoft Corporation.
// Licensed under the MIT License.
import os from "node:os";
import process from "node:process";
/**
 * @internal
 */
export function getHeaderName() {
    return "User-Agent";
}
/**
 * @internal
 */
export async function setPlatformSpecificData(map) {
    if (process && process.versions) {
        const versions = process.versions;
        if (versions.bun) {
            map.set("Bun", versions.bun);
        }
        else if (versions.deno) {
            map.set("Deno", versions.deno);
        }
        else if (versions.node) {
            map.set("Node", versions.node);
        }
    }
    map.set("OS", `(${os.arch()}-${os.type()}-${os.release()})`);
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/7d842fb85a0275a4a8e4d7e040d2625abbf7f084/node_modules/@azure/core-rest-pipeline/dist/esm/util/userAgentPlatform.js.map