"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.verifyManifest = exports.generateManifest = void 0;
const node_crypto_1 = require("node:crypto");
const fs = __importStar(require("node:fs/promises"));
const zip_1 = require("./zip");
const zod_1 = require("zod");
const errors_1 = require("./errors");
const vsixSignatureManifestSchema = zod_1.z.object({
    package: zod_1.z.object({
        size: zod_1.z.number(),
        digests: zod_1.z.object({
            sha256: zod_1.z.string(),
        }),
    }),
    entries: zod_1.z.record(zod_1.z.object({
        size: zod_1.z.number(),
        digests: zod_1.z.object({
            sha256: zod_1.z.string(),
        }),
    })),
});
/**
 * @returns a sha256 hash of the file in base64
 */
const fileSha256 = async (file) => {
    return new Promise((resolve, reject) => {
        try {
            const hash = (0, node_crypto_1.createHash)("sha256");
            hash.update(file);
            const digest = hash.digest("base64");
            resolve(digest);
        }
        catch (error) {
            reject(error);
        }
    });
};
const toBase64 = (string) => Buffer.from(string).toString("base64");
const generateManifest = async (vsixFilePath) => {
    const extensionPackage = await fs.readFile(vsixFilePath);
    const extensionPackageContentsDetails = await (0, zip_1.readZip)(vsixFilePath);
    const entries = {};
    for (const [entryPath, entryContent] of extensionPackageContentsDetails.entries()) {
        const entrySize = entryContent.length;
        const entrySha256 = await fileSha256(entryContent);
        entries[toBase64(entryPath)] = {
            size: entrySize,
            digests: {
                sha256: entrySha256,
            },
        };
    }
    return {
        package: {
            size: extensionPackage.length,
            digests: {
                sha256: await fileSha256(extensionPackage),
            },
        },
        entries,
    };
};
exports.generateManifest = generateManifest;
const verifyManifest = async (manifest, extensionPackagePath) => {
    const { success: isManifestFormatValid } = vsixSignatureManifestSchema.safeParse(manifest);
    if (!isManifestFormatValid) {
        throw new errors_1.ExtensionSignatureVerificationError("SignatureManifestIsInvalid", true, "The signature manifest is malformed");
    }
    const extensionPackage = await fs.readFile(extensionPackagePath);
    const extensionPackageContentsDetails = await (0, zip_1.readZip)(extensionPackagePath);
    if (manifest.package.size !== extensionPackage.length) {
        return false;
    }
    if (manifest.package.digests.sha256 !== (await fileSha256(extensionPackage))) {
        return false;
    }
    for (const [entryPath, entryContent] of extensionPackageContentsDetails.entries()) {
        const entrySize = entryContent.length;
        const entrySha256 = await fileSha256(entryContent);
        if (manifest.entries[toBase64(entryPath)]?.size !== entrySize) {
            throw new errors_1.ExtensionSignatureVerificationError("EntryIsTampered", true, "The entry size has been tampered with");
        }
        if (manifest.entries[toBase64(entryPath)]?.digests.sha256 !== entrySha256) {
            throw new errors_1.ExtensionSignatureVerificationError("EntryIsTampered", true, "The entry content has been tampered with");
        }
    }
    return true;
};
exports.verifyManifest = verifyManifest;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/e3550cfac4b63ca4eafca7b601f0d2885817fd1f/node_modules/node-ovsx-sign/lib/utils/signature-manifest.js.map