﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/servicecatalog/ServiceCatalogRequest.h>
#include <aws/servicecatalog/ServiceCatalog_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ServiceCatalog {
namespace Model {

/**
 */
class DescribeCopyProductStatusRequest : public ServiceCatalogRequest {
 public:
  AWS_SERVICECATALOG_API DescribeCopyProductStatusRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeCopyProductStatus"; }

  AWS_SERVICECATALOG_API Aws::String SerializePayload() const override;

  AWS_SERVICECATALOG_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The language code.</p> <ul> <li> <p> <code>jp</code> - Japanese</p> </li>
   * <li> <p> <code>zh</code> - Chinese</p> </li> </ul>
   */
  inline const Aws::String& GetAcceptLanguage() const { return m_acceptLanguage; }
  inline bool AcceptLanguageHasBeenSet() const { return m_acceptLanguageHasBeenSet; }
  template <typename AcceptLanguageT = Aws::String>
  void SetAcceptLanguage(AcceptLanguageT&& value) {
    m_acceptLanguageHasBeenSet = true;
    m_acceptLanguage = std::forward<AcceptLanguageT>(value);
  }
  template <typename AcceptLanguageT = Aws::String>
  DescribeCopyProductStatusRequest& WithAcceptLanguage(AcceptLanguageT&& value) {
    SetAcceptLanguage(std::forward<AcceptLanguageT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the copy product operation. This token is returned by
   * <a>CopyProduct</a>.</p>
   */
  inline const Aws::String& GetCopyProductToken() const { return m_copyProductToken; }
  inline bool CopyProductTokenHasBeenSet() const { return m_copyProductTokenHasBeenSet; }
  template <typename CopyProductTokenT = Aws::String>
  void SetCopyProductToken(CopyProductTokenT&& value) {
    m_copyProductTokenHasBeenSet = true;
    m_copyProductToken = std::forward<CopyProductTokenT>(value);
  }
  template <typename CopyProductTokenT = Aws::String>
  DescribeCopyProductStatusRequest& WithCopyProductToken(CopyProductTokenT&& value) {
    SetCopyProductToken(std::forward<CopyProductTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_acceptLanguage;
  bool m_acceptLanguageHasBeenSet = false;

  Aws::String m_copyProductToken;
  bool m_copyProductTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace ServiceCatalog
}  // namespace Aws
