﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/bedrock-runtime/BedrockRuntime_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

namespace Aws {
namespace BedrockRuntime {
namespace Model {
enum class ServiceTierType { NOT_SET, priority, default_, flex };

namespace ServiceTierTypeMapper {
AWS_BEDROCKRUNTIME_API ServiceTierType GetServiceTierTypeForName(const Aws::String& name);

AWS_BEDROCKRUNTIME_API Aws::String GetNameForServiceTierType(ServiceTierType value);
}  // namespace ServiceTierTypeMapper
}  // namespace Model
}  // namespace BedrockRuntime
}  // namespace Aws
