﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/LexModelsV2Request.h>
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>

#include <utility>

namespace Aws {
namespace LexModelsV2 {
namespace Model {

/**
 */
class CreateBotReplicaRequest : public LexModelsV2Request {
 public:
  AWS_LEXMODELSV2_API CreateBotReplicaRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "CreateBotReplica"; }

  AWS_LEXMODELSV2_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The request for the unique bot ID of the source bot to be replicated in the
   * secondary region.</p>
   */
  inline const Aws::String& GetBotId() const { return m_botId; }
  inline bool BotIdHasBeenSet() const { return m_botIdHasBeenSet; }
  template <typename BotIdT = Aws::String>
  void SetBotId(BotIdT&& value) {
    m_botIdHasBeenSet = true;
    m_botId = std::forward<BotIdT>(value);
  }
  template <typename BotIdT = Aws::String>
  CreateBotReplicaRequest& WithBotId(BotIdT&& value) {
    SetBotId(std::forward<BotIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The request for the secondary region that will be used in the replication of
   * the source bot.</p>
   */
  inline const Aws::String& GetReplicaRegion() const { return m_replicaRegion; }
  inline bool ReplicaRegionHasBeenSet() const { return m_replicaRegionHasBeenSet; }
  template <typename ReplicaRegionT = Aws::String>
  void SetReplicaRegion(ReplicaRegionT&& value) {
    m_replicaRegionHasBeenSet = true;
    m_replicaRegion = std::forward<ReplicaRegionT>(value);
  }
  template <typename ReplicaRegionT = Aws::String>
  CreateBotReplicaRequest& WithReplicaRegion(ReplicaRegionT&& value) {
    SetReplicaRegion(std::forward<ReplicaRegionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_botId;
  bool m_botIdHasBeenSet = false;

  Aws::String m_replicaRegion;
  bool m_replicaRegionHasBeenSet = false;
};

}  // namespace Model
}  // namespace LexModelsV2
}  // namespace Aws
