﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/lexv2-models/LexModelsV2_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lexv2-models/model/ExactResponseFields.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace LexModelsV2
{
namespace Model
{

  /**
   * <p>Contains details about the configuration of the Amazon OpenSearch Service
   * database used for the <code>AMAZON.QnAIntent</code>.</p><p><h3>See Also:</h3>  
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/models.lex.v2-2020-08-07/OpensearchConfiguration">AWS
   * API Reference</a></p>
   */
  class OpensearchConfiguration
  {
  public:
    AWS_LEXMODELSV2_API OpensearchConfiguration() = default;
    AWS_LEXMODELSV2_API OpensearchConfiguration(Aws::Utils::Json::JsonView jsonValue);
    AWS_LEXMODELSV2_API OpensearchConfiguration& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_LEXMODELSV2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The endpoint of the Amazon OpenSearch Service domain.</p>
     */
    inline const Aws::String& GetDomainEndpoint() const { return m_domainEndpoint; }
    inline bool DomainEndpointHasBeenSet() const { return m_domainEndpointHasBeenSet; }
    template<typename DomainEndpointT = Aws::String>
    void SetDomainEndpoint(DomainEndpointT&& value) { m_domainEndpointHasBeenSet = true; m_domainEndpoint = std::forward<DomainEndpointT>(value); }
    template<typename DomainEndpointT = Aws::String>
    OpensearchConfiguration& WithDomainEndpoint(DomainEndpointT&& value) { SetDomainEndpoint(std::forward<DomainEndpointT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of the Amazon OpenSearch Service index.</p>
     */
    inline const Aws::String& GetIndexName() const { return m_indexName; }
    inline bool IndexNameHasBeenSet() const { return m_indexNameHasBeenSet; }
    template<typename IndexNameT = Aws::String>
    void SetIndexName(IndexNameT&& value) { m_indexNameHasBeenSet = true; m_indexName = std::forward<IndexNameT>(value); }
    template<typename IndexNameT = Aws::String>
    OpensearchConfiguration& WithIndexName(IndexNameT&& value) { SetIndexName(std::forward<IndexNameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Specifies whether to return an exact response or to return an answer
     * generated by the model using the fields you specify from the database.</p>
     */
    inline bool GetExactResponse() const { return m_exactResponse; }
    inline bool ExactResponseHasBeenSet() const { return m_exactResponseHasBeenSet; }
    inline void SetExactResponse(bool value) { m_exactResponseHasBeenSet = true; m_exactResponse = value; }
    inline OpensearchConfiguration& WithExactResponse(bool value) { SetExactResponse(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains the names of the fields used for an exact response to the user.</p>
     */
    inline const ExactResponseFields& GetExactResponseFields() const { return m_exactResponseFields; }
    inline bool ExactResponseFieldsHasBeenSet() const { return m_exactResponseFieldsHasBeenSet; }
    template<typename ExactResponseFieldsT = ExactResponseFields>
    void SetExactResponseFields(ExactResponseFieldsT&& value) { m_exactResponseFieldsHasBeenSet = true; m_exactResponseFields = std::forward<ExactResponseFieldsT>(value); }
    template<typename ExactResponseFieldsT = ExactResponseFields>
    OpensearchConfiguration& WithExactResponseFields(ExactResponseFieldsT&& value) { SetExactResponseFields(std::forward<ExactResponseFieldsT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Contains a list of fields from the Amazon OpenSearch Service that the model
     * can use to generate the answer to the query.</p>
     */
    inline const Aws::Vector<Aws::String>& GetIncludeFields() const { return m_includeFields; }
    inline bool IncludeFieldsHasBeenSet() const { return m_includeFieldsHasBeenSet; }
    template<typename IncludeFieldsT = Aws::Vector<Aws::String>>
    void SetIncludeFields(IncludeFieldsT&& value) { m_includeFieldsHasBeenSet = true; m_includeFields = std::forward<IncludeFieldsT>(value); }
    template<typename IncludeFieldsT = Aws::Vector<Aws::String>>
    OpensearchConfiguration& WithIncludeFields(IncludeFieldsT&& value) { SetIncludeFields(std::forward<IncludeFieldsT>(value)); return *this;}
    template<typename IncludeFieldsT = Aws::String>
    OpensearchConfiguration& AddIncludeFields(IncludeFieldsT&& value) { m_includeFieldsHasBeenSet = true; m_includeFields.emplace_back(std::forward<IncludeFieldsT>(value)); return *this; }
    ///@}
  private:

    Aws::String m_domainEndpoint;
    bool m_domainEndpointHasBeenSet = false;

    Aws::String m_indexName;
    bool m_indexNameHasBeenSet = false;

    bool m_exactResponse{false};
    bool m_exactResponseHasBeenSet = false;

    ExactResponseFields m_exactResponseFields;
    bool m_exactResponseFieldsHasBeenSet = false;

    Aws::Vector<Aws::String> m_includeFields;
    bool m_includeFieldsHasBeenSet = false;
  };

} // namespace Model
} // namespace LexModelsV2
} // namespace Aws
