﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/guardduty/GuardDuty_EXPORTS.h>
#include <aws/guardduty/model/MalwareProtectionPlanTaggingAction.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GuardDuty
{
namespace Model
{

  /**
   * <p>Information about whether the tags will be added to the S3 object after
   * scanning.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/MalwareProtectionPlanActions">AWS
   * API Reference</a></p>
   */
  class MalwareProtectionPlanActions
  {
  public:
    AWS_GUARDDUTY_API MalwareProtectionPlanActions() = default;
    AWS_GUARDDUTY_API MalwareProtectionPlanActions(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API MalwareProtectionPlanActions& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GUARDDUTY_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>Indicates whether the scanned S3 object will have tags about the scan
     * result.</p>
     */
    inline const MalwareProtectionPlanTaggingAction& GetTagging() const { return m_tagging; }
    inline bool TaggingHasBeenSet() const { return m_taggingHasBeenSet; }
    template<typename TaggingT = MalwareProtectionPlanTaggingAction>
    void SetTagging(TaggingT&& value) { m_taggingHasBeenSet = true; m_tagging = std::forward<TaggingT>(value); }
    template<typename TaggingT = MalwareProtectionPlanTaggingAction>
    MalwareProtectionPlanActions& WithTagging(TaggingT&& value) { SetTagging(std::forward<TaggingT>(value)); return *this;}
    ///@}
  private:

    MalwareProtectionPlanTaggingAction m_tagging;
    bool m_taggingHasBeenSet = false;
  };

} // namespace Model
} // namespace GuardDuty
} // namespace Aws
