﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/route53-recovery-readiness/Route53RecoveryReadiness_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Route53RecoveryReadiness
{
namespace Model
{
  class ListCrossAccountAuthorizationsResult
  {
  public:
    AWS_ROUTE53RECOVERYREADINESS_API ListCrossAccountAuthorizationsResult() = default;
    AWS_ROUTE53RECOVERYREADINESS_API ListCrossAccountAuthorizationsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ROUTE53RECOVERYREADINESS_API ListCrossAccountAuthorizationsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>A list of cross-account authorizations.</p>
     */
    inline const Aws::Vector<Aws::String>& GetCrossAccountAuthorizations() const { return m_crossAccountAuthorizations; }
    template<typename CrossAccountAuthorizationsT = Aws::Vector<Aws::String>>
    void SetCrossAccountAuthorizations(CrossAccountAuthorizationsT&& value) { m_crossAccountAuthorizationsHasBeenSet = true; m_crossAccountAuthorizations = std::forward<CrossAccountAuthorizationsT>(value); }
    template<typename CrossAccountAuthorizationsT = Aws::Vector<Aws::String>>
    ListCrossAccountAuthorizationsResult& WithCrossAccountAuthorizations(CrossAccountAuthorizationsT&& value) { SetCrossAccountAuthorizations(std::forward<CrossAccountAuthorizationsT>(value)); return *this;}
    template<typename CrossAccountAuthorizationsT = Aws::String>
    ListCrossAccountAuthorizationsResult& AddCrossAccountAuthorizations(CrossAccountAuthorizationsT&& value) { m_crossAccountAuthorizationsHasBeenSet = true; m_crossAccountAuthorizations.emplace_back(std::forward<CrossAccountAuthorizationsT>(value)); return *this; }
    ///@}

    ///@{
    /**
     * <p>The token that identifies which batch of results you want to see.</p>
     */
    inline const Aws::String& GetNextToken() const { return m_nextToken; }
    template<typename NextTokenT = Aws::String>
    void SetNextToken(NextTokenT&& value) { m_nextTokenHasBeenSet = true; m_nextToken = std::forward<NextTokenT>(value); }
    template<typename NextTokenT = Aws::String>
    ListCrossAccountAuthorizationsResult& WithNextToken(NextTokenT&& value) { SetNextToken(std::forward<NextTokenT>(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const { return m_requestId; }
    template<typename RequestIdT = Aws::String>
    void SetRequestId(RequestIdT&& value) { m_requestIdHasBeenSet = true; m_requestId = std::forward<RequestIdT>(value); }
    template<typename RequestIdT = Aws::String>
    ListCrossAccountAuthorizationsResult& WithRequestId(RequestIdT&& value) { SetRequestId(std::forward<RequestIdT>(value)); return *this;}
    ///@}
  private:

    Aws::Vector<Aws::String> m_crossAccountAuthorizations;
    bool m_crossAccountAuthorizationsHasBeenSet = false;

    Aws::String m_nextToken;
    bool m_nextTokenHasBeenSet = false;

    Aws::String m_requestId;
    bool m_requestIdHasBeenSet = false;
  };

} // namespace Model
} // namespace Route53RecoveryReadiness
} // namespace Aws
