﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/inspector2/Inspector2_EXPORTS.h>
#include <aws/core/utils/DateTime.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace Inspector2
{
namespace Model
{

  /**
   * <p>Contains information on when this exploit was observed.</p><p><h3>See
   * Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/inspector2-2020-06-08/ExploitObserved">AWS
   * API Reference</a></p>
   */
  class ExploitObserved
  {
  public:
    AWS_INSPECTOR2_API ExploitObserved() = default;
    AWS_INSPECTOR2_API ExploitObserved(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API ExploitObserved& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_INSPECTOR2_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The date an time when the exploit was last seen.</p>
     */
    inline const Aws::Utils::DateTime& GetLastSeen() const { return m_lastSeen; }
    inline bool LastSeenHasBeenSet() const { return m_lastSeenHasBeenSet; }
    template<typename LastSeenT = Aws::Utils::DateTime>
    void SetLastSeen(LastSeenT&& value) { m_lastSeenHasBeenSet = true; m_lastSeen = std::forward<LastSeenT>(value); }
    template<typename LastSeenT = Aws::Utils::DateTime>
    ExploitObserved& WithLastSeen(LastSeenT&& value) { SetLastSeen(std::forward<LastSeenT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The date an time when the exploit was first seen.</p>
     */
    inline const Aws::Utils::DateTime& GetFirstSeen() const { return m_firstSeen; }
    inline bool FirstSeenHasBeenSet() const { return m_firstSeenHasBeenSet; }
    template<typename FirstSeenT = Aws::Utils::DateTime>
    void SetFirstSeen(FirstSeenT&& value) { m_firstSeenHasBeenSet = true; m_firstSeen = std::forward<FirstSeenT>(value); }
    template<typename FirstSeenT = Aws::Utils::DateTime>
    ExploitObserved& WithFirstSeen(FirstSeenT&& value) { SetFirstSeen(std::forward<FirstSeenT>(value)); return *this;}
    ///@}
  private:

    Aws::Utils::DateTime m_lastSeen{};
    bool m_lastSeenHasBeenSet = false;

    Aws::Utils::DateTime m_firstSeen{};
    bool m_firstSeenHasBeenSet = false;
  };

} // namespace Model
} // namespace Inspector2
} // namespace Aws
