﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/databrew/GlueDataBrew_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/databrew/model/S3TableOutputOptions.h>
#include <aws/databrew/model/DatabaseTableOutputOptions.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace GlueDataBrew
{
namespace Model
{

  /**
   * <p>Represents options that specify how and where in the Glue Data Catalog
   * DataBrew writes the output generated by recipe jobs.</p><p><h3>See Also:</h3>  
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/databrew-2017-07-25/DataCatalogOutput">AWS
   * API Reference</a></p>
   */
  class DataCatalogOutput
  {
  public:
    AWS_GLUEDATABREW_API DataCatalogOutput() = default;
    AWS_GLUEDATABREW_API DataCatalogOutput(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUEDATABREW_API DataCatalogOutput& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_GLUEDATABREW_API Aws::Utils::Json::JsonValue Jsonize() const;


    ///@{
    /**
     * <p>The unique identifier of the Amazon Web Services account that holds the Data
     * Catalog that stores the data.</p>
     */
    inline const Aws::String& GetCatalogId() const { return m_catalogId; }
    inline bool CatalogIdHasBeenSet() const { return m_catalogIdHasBeenSet; }
    template<typename CatalogIdT = Aws::String>
    void SetCatalogId(CatalogIdT&& value) { m_catalogIdHasBeenSet = true; m_catalogId = std::forward<CatalogIdT>(value); }
    template<typename CatalogIdT = Aws::String>
    DataCatalogOutput& WithCatalogId(CatalogIdT&& value) { SetCatalogId(std::forward<CatalogIdT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of a database in the Data Catalog.</p>
     */
    inline const Aws::String& GetDatabaseName() const { return m_databaseName; }
    inline bool DatabaseNameHasBeenSet() const { return m_databaseNameHasBeenSet; }
    template<typename DatabaseNameT = Aws::String>
    void SetDatabaseName(DatabaseNameT&& value) { m_databaseNameHasBeenSet = true; m_databaseName = std::forward<DatabaseNameT>(value); }
    template<typename DatabaseNameT = Aws::String>
    DataCatalogOutput& WithDatabaseName(DatabaseNameT&& value) { SetDatabaseName(std::forward<DatabaseNameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The name of a table in the Data Catalog.</p>
     */
    inline const Aws::String& GetTableName() const { return m_tableName; }
    inline bool TableNameHasBeenSet() const { return m_tableNameHasBeenSet; }
    template<typename TableNameT = Aws::String>
    void SetTableName(TableNameT&& value) { m_tableNameHasBeenSet = true; m_tableName = std::forward<TableNameT>(value); }
    template<typename TableNameT = Aws::String>
    DataCatalogOutput& WithTableName(TableNameT&& value) { SetTableName(std::forward<TableNameT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Represents options that specify how and where DataBrew writes the Amazon S3
     * output generated by recipe jobs.</p>
     */
    inline const S3TableOutputOptions& GetS3Options() const { return m_s3Options; }
    inline bool S3OptionsHasBeenSet() const { return m_s3OptionsHasBeenSet; }
    template<typename S3OptionsT = S3TableOutputOptions>
    void SetS3Options(S3OptionsT&& value) { m_s3OptionsHasBeenSet = true; m_s3Options = std::forward<S3OptionsT>(value); }
    template<typename S3OptionsT = S3TableOutputOptions>
    DataCatalogOutput& WithS3Options(S3OptionsT&& value) { SetS3Options(std::forward<S3OptionsT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>Represents options that specify how and where DataBrew writes the database
     * output generated by recipe jobs.</p>
     */
    inline const DatabaseTableOutputOptions& GetDatabaseOptions() const { return m_databaseOptions; }
    inline bool DatabaseOptionsHasBeenSet() const { return m_databaseOptionsHasBeenSet; }
    template<typename DatabaseOptionsT = DatabaseTableOutputOptions>
    void SetDatabaseOptions(DatabaseOptionsT&& value) { m_databaseOptionsHasBeenSet = true; m_databaseOptions = std::forward<DatabaseOptionsT>(value); }
    template<typename DatabaseOptionsT = DatabaseTableOutputOptions>
    DataCatalogOutput& WithDatabaseOptions(DatabaseOptionsT&& value) { SetDatabaseOptions(std::forward<DatabaseOptionsT>(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A value that, if true, means that any data in the location specified for
     * output is overwritten with new output. Not supported with DatabaseOptions.</p>
     */
    inline bool GetOverwrite() const { return m_overwrite; }
    inline bool OverwriteHasBeenSet() const { return m_overwriteHasBeenSet; }
    inline void SetOverwrite(bool value) { m_overwriteHasBeenSet = true; m_overwrite = value; }
    inline DataCatalogOutput& WithOverwrite(bool value) { SetOverwrite(value); return *this;}
    ///@}
  private:

    Aws::String m_catalogId;
    bool m_catalogIdHasBeenSet = false;

    Aws::String m_databaseName;
    bool m_databaseNameHasBeenSet = false;

    Aws::String m_tableName;
    bool m_tableNameHasBeenSet = false;

    S3TableOutputOptions m_s3Options;
    bool m_s3OptionsHasBeenSet = false;

    DatabaseTableOutputOptions m_databaseOptions;
    bool m_databaseOptionsHasBeenSet = false;

    bool m_overwrite{false};
    bool m_overwriteHasBeenSet = false;
  };

} // namespace Model
} // namespace GlueDataBrew
} // namespace Aws
