#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-48JXIlDlkU2C7p0HTV4fvZ
key:                  arch-hs-0.12.1-48JXIlDlkU2C7p0HTV4fvZ
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  10168c540a32437ab94fef8644949fa1
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-48JXIlDlkU2C7p0HTV4fvZ
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-hI2uHmB4lS7QvAxM5sFWw
    aeson-2.1.2.1-LvJWrHbVhNW5j5NGQeCpIT
    algebraic-graphs-0.7-2EHQvdsB7jqSYstPWRBu9
    arch-web-0.3.2-B7eyvhCzOAz2xrimxwca88 base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-7gDrgQT36z4IN6MqKXM4jU
    conduit-extra-1.3.8-LH0nSmNEDBz6QpPwrMyaiE containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-DqMdH4oDxvpFG3ufxvqbwe
    http-client-0.7.19-FAI99Ioi5R36WLiLxr7VX7
    http-client-tls-0.3.6.4-GiVBNNbKgJLCx3fO8pPpRI
    megaparsec-9.7.0-3kDa2AKG8BH1ETde5AtQpM
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-JPb9gYUExozDYMrhOJfNAh
    optparse-simple-0.1.1.4-CEmA7jUPZasJf6oVGwHwzL
    polysemy-1.9.2.0-9mE1oQtEfjP1UOf5BC7mRm
    prettyprinter-1.7.1-2R6NgwfUgVc9iM5YqEeKHX
    prettyprinter-ansi-terminal-1.1.3-18v05W538YvI18BbSi9hYg
    servant-client-0.20.3.0-EChnqc3nVpeonRNvII8ds
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tar-conduit-0.4.1-7Xo1qPsIQtT2ztIhZHt5A3 template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

