#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.1
visibility:           public
id:                   arch-hs-0.12.1-12mP6vErpGmBxUjETZGMjl
key:                  arch-hs-0.12.1-12mP6vErpGmBxUjETZGMjl
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  35f25bc28aa0afa6f6cebc0388196b22
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.1-12mP6vErpGmBxUjETZGMjl
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.1/include
depends:
    Cabal-3.8.1.0 Diff-0.5-8Hys7qBFsDx3PrDtGKpYZN
    aeson-2.1.2.1-30WJrKK1Pbc1pP0H7Lz8HG
    algebraic-graphs-0.7-9PfF8WwioXk4vdijpDnvv2
    arch-web-0.3.2-4AaMboZSTL42NF4WTIgPOw base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-L9TggbIlNiTCDF5rGZVa9g
    conduit-extra-1.3.8-19lmWL4nfT7KBh5mbFf6Y1 containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-9S30epbRBWh8zlXaEGPW4h
    http-client-0.7.19-E75obOxKY6lFjozf9B0Cdj
    http-client-tls-0.3.6.4-JnWaCoPi7KZ8DaHdfoFfuf
    megaparsec-9.7.0-3uOOds7dkmdKa9eAfy4ha7
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-Idzxa80CXtcG6AzfDIJHo4
    optparse-simple-0.1.1.4-7nLyAqVKNYfKaSAlq9NaQm
    polysemy-1.9.2.0-BOKSprFhMwyFCdXdfxelOZ
    prettyprinter-1.7.1-GISel4GwMefHj3FidpnW09
    prettyprinter-ansi-terminal-1.1.3-8UOwX8rKTlo26LHvvVWgFr
    servant-client-0.20.3.0-3HE47iTvXkmABV4yzHv4Kv
    split-0.2.5-BTOw45Vh0HiC6vu4BN5MeO
    tar-conduit-0.4.1-MmtNkTV6mWGRbbGNxoImJ template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

