#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.4
visibility:           public
id:                   arch-hs-0.12.0.4-AGFRTINwl1iAFra4ryhFMl
key:                  arch-hs-0.12.0.4-AGFRTINwl1iAFra4ryhFMl
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  5ffc48d1624994dd87e06d54c47212cf
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.4-AGFRTINwl1iAFra4ryhFMl
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.4/include
depends:
    Cabal-3.8.1.0 Diff-0.5-GzUbzmeQvoG8gRPGshhW48
    aeson-2.1.2.1-GhEX0nU3rpe2rpNz8TrqEz
    algebraic-graphs-0.7-8eYmRC5WBObJ4tnXfHsPtc
    arch-web-0.3.1-1YoOeYUp3iAA77sgBC8tE2 base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-4gghCzlDHkwDP6CgdQyket
    conduit-extra-1.3.8-G9lFzvhsWCC98MvCUjkory containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-JzL7wzlTwDJOOPKK3Ai6T
    http-client-0.7.19-2gxWIBw6DZOLOrOirSGCjs
    http-client-tls-0.3.6.4-ASsMA44245pH60llfmtwLM
    megaparsec-9.7.0-4uCmo2rz8QPI88LtUBVGYi
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-LrMe5XTRfEzAM9ERzCaCEg
    optparse-simple-0.1.1.4-4BffvzzleQM2sKS0iXrHLI
    polysemy-1.9.2.0-JgWZTMpNFZ54HRBs5N4h8k
    prettyprinter-1.7.1-Hi17Zu3O6FiIO5eybHbcRR
    prettyprinter-ansi-terminal-1.1.3-1sT1NT5hMp2CeTvXMcpM3w
    servant-client-0.20.3.0-2vm0NnRIPSR7w6B4cuSaDQ
    split-0.2.5-Dujwwofvw7aEFmjRmWhj9Q
    tar-conduit-0.4.1-5xl8G7hSt1kK6hke4WjAYX template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

