#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arch-hs
version:              0.12.0.3
visibility:           public
id:                   arch-hs-0.12.0.3-6vKcA7g8oKJKR2MPptXzDy
key:                  arch-hs-0.12.0.3-6vKcA7g8oKJKR2MPptXzDy
license:              MIT
copyright:            (c) 2020-2022 berberman
maintainer:           berberman <berberman@yandex.com>
author:               berberman
homepage:             https://github.com/berberman/arch-hs
synopsis:             Distribute hackage packages to archlinux
description:
    @arch-hs@ is a command-line program, which simplifies the process of producing
    and maintaining haskell packages for archlinux distribution by automating the
    PKGBUILD generation with the dependency resolving and template filling. Currently,
    @arch-hs@ is unstable, so packagers should not trust it 100%, but always follow the
    <https://wiki.archlinux.org/index.php/Haskell_package_guidelines Haskell package guidelines>.

category:             Distribution
abi:                  fb47ad13d72c71cebda4950438f37a5e
exposed:              True
exposed-modules:
    Distribution.ArchHs.Aur Distribution.ArchHs.Compat
    Distribution.ArchHs.Core Distribution.ArchHs.Exception
    Distribution.ArchHs.ExtraDB Distribution.ArchHs.FilesDB
    Distribution.ArchHs.Hackage Distribution.ArchHs.Internal.Prelude
    Distribution.ArchHs.Local Distribution.ArchHs.Name
    Distribution.ArchHs.Options Distribution.ArchHs.PP
    Distribution.ArchHs.PkgBuild Distribution.ArchHs.PkgDesc
    Distribution.ArchHs.Types Distribution.ArchHs.Utils

hidden-modules:
    Distribution.ArchHs.Internal.NamePresetLoader Paths_arch_hs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/arch-hs
hs-libraries:         HSarch-hs-0.12.0.3-6vKcA7g8oKJKR2MPptXzDy
extra-libraries:      alpm
include-dirs:         /usr/lib/ghc-9.4.8/site-local/arch-hs-0.12.0.3/include
depends:
    Cabal-3.8.1.0 Diff-0.4.1-HEnssu43s0k5bU1IlZ6xfs
    aeson-2.1.2.1-HPwo2VO3hzcFr4fiGB5Oro
    algebraic-graphs-0.7-CWYc7662wPW98hQRY8fkp4
    arch-web-0.3.1-17c1LEZXgFq17PY1BIWNgo base-4.17.2.1
    bytestring-0.11.5.3 conduit-1.3.6.1-CuuvisR1uAaJsPmK0tVtaN
    conduit-extra-1.3.8-BcW7Hf7I2YE6crDjGlMLQy containers-0.6.7
    deepseq-1.4.8.0 directory-1.3.7.1 filepath-1.4.2.2
    hackage-db-2.1.3-KR2NfCJ0BbrD0iP3nFuUAB
    http-client-0.7.18-IROMjfUUOqe2MZRLGJEp23
    http-client-tls-0.3.6.4-6ZcD1iDGS9Y6vJRxoNTqij
    megaparsec-9.6.1-EACNQE4V0s4sorPNkNSJS
    microlens-0.4.14.0-71jOCsiFFF8LaovsPy6HDt
    microlens-th-0.4.3.17-GRXwDxs8Aw09PQskuAg669
    neat-interpolation-0.5.1.4-8szl6cukie2DJfwnSrQxqr
    optparse-simple-0.1.1.4-VVZJ5YLPNy2Hc54Yf9ZzS
    polysemy-1.9.2.0-EtiE1G4sB7D3OWWXoBxXKP
    prettyprinter-1.7.1-CblNKNR1eKT9nxUoBiyJi9
    prettyprinter-ansi-terminal-1.1.3-BetCIThzEOW7GW5IXaiUDk
    servant-client-0.20.2-4kEGRELIo08DpWOyoe99dc
    split-0.2.5-JeJxVdKJRKMda8iubaxqh
    tar-conduit-0.4.1-KtymFsrRCEl4jtB7yalHXA template-haskell-2.19.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/arch-hs/html/arch-hs.haddock
haddock-html:         /usr/share/doc/arch-hs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

