/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyDataclassParameters;
import com.jetbrains.python.codeInsight.PyDataclassesKt;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/python/inspections/PyThirdPartyInspectionExtension;", "Lcom/jetbrains/python/inspections/PyInspectionExtension;", "<init>", "()V", "ignoreMethodParameters", "", "function", "Lcom/jetbrains/python/psi/PyFunction;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "ignoreUnresolvedMember", "type", "Lcom/jetbrains/python/psi/types/PyType;", "name", "", "resolvesTo", "expression", "Lcom/jetbrains/python/psi/PyExpression;", "qualifiedName", "resolveContext", "Lcom/jetbrains/python/psi/resolve/PyResolveContext;", "intellij.python.community.impl"})
public final class PyThirdPartyInspectionExtension
extends PyInspectionExtension {
    public boolean ignoreMethodParameters(@NotNull PyFunction function, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyClass cls = function.getContainingClass();
        if (cls != null) {
            String interfaceQName = "zope.interface.interface.Interface";
            if (cls.isSubclass(interfaceQName, context)) {
                return true;
            }
            PyResolveContext pyResolveContext = PyResolveContext.defaultContext((TypeEvalContext)context);
            Intrinsics.checkNotNullExpressionValue((Object)pyResolveContext, (String)"defaultContext(...)");
            PyResolveContext resolveContext = pyResolveContext;
            PyExpression[] pyExpressionArray = cls.getSuperClassExpressions();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getSuperClassExpressions(...)");
            for (PyExpression expression : pyExpressionArray) {
                Intrinsics.checkNotNull((Object)expression);
                if (!this.resolvesTo(expression, interfaceQName, resolveContext)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean ignoreUnresolvedMember(@NotNull PyType type2, @NotNull String name2, @NotNull TypeEvalContext context) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)name2, (Object)"__attrs_attrs__")) return false;
        if (!(type2 instanceof PyClassType)) return false;
        PyClass pyClass = ((PyClassType)type2).getPyClass();
        Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
        PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseDataclassParameters((PyClass)pyClass, (TypeEvalContext)context);
        if ((pyDataclassParameters != null && (pyDataclassParameters = pyDataclassParameters.getType()) != null ? pyDataclassParameters.getAsPredefinedType() : null) != PyDataclassParameters.PredefinedType.ATTRS) return false;
        return true;
    }

    private final boolean resolvesTo(PyExpression expression, String qualifiedName, PyResolveContext resolveContext) {
        return ContainerUtil.exists((Iterable)PyUtil.multiResolveTopPriority((PsiElement)((PsiElement)expression), (PyResolveContext)resolveContext), arg_0 -> PyThirdPartyInspectionExtension.resolvesTo$lambda$1(arg_0 -> PyThirdPartyInspectionExtension.resolvesTo$lambda$0(qualifiedName, arg_0), arg_0));
    }

    private static final boolean resolvesTo$lambda$0(String $qualifiedName, PsiElement it) {
        return it instanceof PyElement && Intrinsics.areEqual((Object)QualifiedNameFinder.getQualifiedName((PyElement)((PyElement)it)), (Object)$qualifiedName);
    }

    private static final boolean resolvesTo$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

