/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.util.NlsActions;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.AbstractPolicy;
import com.jetbrains.python.debugger.PolicyListener;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.QuotingPolicy;
import com.jetbrains.python.debugger.ValuesPolicy;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyVariableViewSettings {
    public static void showWarningMessage(@Nullable XCompositeNode node) {
        if (node == null) {
            return;
        }
        final PyDebuggerSettings debuggerSettings = PyDebuggerSettings.getInstance();
        if (debuggerSettings.getValuesPolicy() == ValuesPolicy.ON_DEMAND) {
            return;
        }
        node.setMessage(PyBundle.message("debugger.variables.view.warning.message", new Object[0]), AllIcons.General.BalloonWarning, SimpleTextAttributes.REGULAR_ATTRIBUTES, new XDebuggerTreeNodeHyperlink(PyBundle.message("debugger.variables.view.switch.to.loading.on.demand", new Object[0])){
            private boolean linkClicked;
            {
                super(arg0);
                this.linkClicked = false;
            }

            public void onClick(MouseEvent event) {
                debuggerSettings.setValuesPolicy(ValuesPolicy.ON_DEMAND);
                this.linkClicked = true;
            }

            @NotNull
            public String getLinkText() {
                if (this.linkClicked) {
                    return "";
                }
                String string = PyBundle.message("debugger.variables.view.switch.to.loading.on.demand", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/debugger/PyVariableViewSettings$1", "getLinkText"));
            }
        });
    }

    public static abstract class AbstractPolicyGroup<Policy extends AbstractPolicy, PolicyAction extends AbstractPolicyAction<Policy, ? extends DefaultActionGroup>>
    extends DefaultActionGroup {
        @NotNull
        private final List<PolicyAction> myPolicyActions = new ArrayList<PolicyAction>();
        private final List<PolicyListener> myPolicyListeners = new ArrayList<PolicyListener>();

        private AbstractPolicyGroup(@NlsActions.ActionText String name2) {
            super(name2, true);
        }

        public void addPolicyActions(PolicyAction ... actions) {
            this.myPolicyActions.addAll(List.of(actions));
            for (AnAction action : this.myPolicyActions) {
                this.add(action);
            }
        }

        public void notifyPolicyUpdated() {
            for (PolicyListener listener2 : this.myPolicyListeners) {
                listener2.valuesPolicyUpdated();
            }
        }

        public void addValuesPolicyListener(@NotNull PolicyListener listener2) {
            if (listener2 == null) {
                AbstractPolicyGroup.$$$reportNull$$$0(0);
            }
            this.myPolicyListeners.add(listener2);
        }

        protected void updatePolicyActions() {
            AbstractPolicy currentPolicy = this.getDebuggerPolicy();
            Iterator<PolicyAction> iterator = this.myPolicyActions.iterator();
            while (iterator.hasNext()) {
                AbstractPolicyAction action;
                action.setEnabled(currentPolicy == (action = (AbstractPolicyAction)((Object)iterator.next())).getPolicy());
            }
        }

        protected abstract AbstractPolicy getDebuggerPolicy();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/jetbrains/python/debugger/PyVariableViewSettings$AbstractPolicyGroup", "addValuesPolicyListener"));
        }
    }

    private static abstract class AbstractPolicyAction<Policy extends AbstractPolicy, PolicyGroup extends AbstractPolicyGroup<Policy, ? extends ToggleAction>>
    extends ToggleAction {
        @NotNull
        private final Policy myPolicy;
        @NotNull
        private final PolicyGroup myActionGroup;
        private volatile boolean isEnabled;

        private AbstractPolicyAction(@NotNull @Nls String text, @NotNull @Nls String description, @NotNull Policy policy, @NotNull PolicyGroup actionGroup) {
            if (text == null) {
                AbstractPolicyAction.$$$reportNull$$$0(0);
            }
            if (description == null) {
                AbstractPolicyAction.$$$reportNull$$$0(1);
            }
            if (policy == null) {
                AbstractPolicyAction.$$$reportNull$$$0(2);
            }
            if (actionGroup == null) {
                AbstractPolicyAction.$$$reportNull$$$0(3);
            }
            super(text, description, null);
            this.myPolicy = policy;
            this.myActionGroup = actionGroup;
            this.isEnabled = PyDebuggerSettings.getInstance().getValuesPolicy() == policy;
        }

        @NotNull
        public PolicyGroup getActionGroup() {
            PolicyGroup PolicyGroup = this.myActionGroup;
            if (PolicyGroup == null) {
                AbstractPolicyAction.$$$reportNull$$$0(4);
            }
            return PolicyGroup;
        }

        @NotNull
        public Policy getPolicy() {
            Policy Policy = this.myPolicy;
            if (Policy == null) {
                AbstractPolicyAction.$$$reportNull$$$0(5);
            }
            return Policy;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                AbstractPolicyAction.$$$reportNull$$$0(6);
            }
            super.update(e);
            ((AbstractPolicyGroup)((Object)this.myActionGroup)).updatePolicyActions();
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                AbstractPolicyAction.$$$reportNull$$$0(7);
            }
            return actionUpdateThread;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                AbstractPolicyAction.$$$reportNull$$$0(8);
            }
            return this.isEnabled;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean hide) {
            if (e == null) {
                AbstractPolicyAction.$$$reportNull$$$0(9);
            }
            this.isEnabled = hide;
            if (hide) {
                this.changeDebuggerSettings();
                ((AbstractPolicyGroup)((Object)this.myActionGroup)).notifyPolicyUpdated();
            }
            ((AbstractPolicyGroup)((Object)this.myActionGroup)).updatePolicyActions();
        }

        protected abstract void changeDebuggerSettings();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "policy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionGroup";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyVariableViewSettings$AbstractPolicyAction";
                    break;
                }
                case 6: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyVariableViewSettings$AbstractPolicyAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionGroup";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPolicy";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static final class QuotingPolicyGroup
    extends AbstractPolicyGroup<QuotingPolicy, QuotingPolicyAction> {
        public QuotingPolicyGroup() {
            super(PyBundle.message("debugger.variables.view.quoting.policy", new Object[0]));
            this.addPolicyActions(new QuotingPolicyAction[]{new QuotingPolicyAction(PyBundle.message("debugger.variables.view.quoting.single.text", new Object[0]), PyBundle.message("debugger.variables.view.quoting.single.description", new Object[0]), QuotingPolicy.SINGLE, this), new QuotingPolicyAction(PyBundle.message("debugger.variables.view.quoting.double.text", new Object[0]), PyBundle.message("debugger.variables.view.quoting.double.description", new Object[0]), QuotingPolicy.DOUBLE, this), new QuotingPolicyAction(PyBundle.message("debugger.variables.view.quoting.without.text", new Object[0]), PyBundle.message("debugger.variables.view.quoting.without.description", new Object[0]), QuotingPolicy.NONE, this)});
        }

        protected QuotingPolicy getDebuggerPolicy() {
            return PyDebuggerSettings.getInstance().getQuotingPolicy();
        }
    }

    public static final class QuotingPolicyAction
    extends AbstractPolicyAction<QuotingPolicy, QuotingPolicyGroup> {
        public QuotingPolicyAction(@Nls @NotNull String text, @Nls @NotNull String description, @NotNull QuotingPolicy policy, @NotNull QuotingPolicyGroup actionGroup) {
            if (text == null) {
                QuotingPolicyAction.$$$reportNull$$$0(0);
            }
            if (description == null) {
                QuotingPolicyAction.$$$reportNull$$$0(1);
            }
            if (policy == null) {
                QuotingPolicyAction.$$$reportNull$$$0(2);
            }
            if (actionGroup == null) {
                QuotingPolicyAction.$$$reportNull$$$0(3);
            }
            super(text, description, policy, actionGroup);
        }

        @Override
        protected void changeDebuggerSettings() {
            PyDebuggerSettings.getInstance().setQuotingPolicy((QuotingPolicy)this.getPolicy());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "policy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionGroup";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/PyVariableViewSettings$QuotingPolicyAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class VariablesPolicyGroup
    extends AbstractPolicyGroup<ValuesPolicy, VariablePolicyAction> {
        public VariablesPolicyGroup() {
            super(PyBundle.message("debugger.variables.loading.policy", new Object[0]));
            this.addPolicyActions(new VariablePolicyAction[]{new VariablePolicyAction(PyBundle.message("debugger.variables.loading.synchronously.text", new Object[0]), PyBundle.message("debugger.variables.loading.synchronously.description", new Object[0]), ValuesPolicy.SYNC, this), new VariablePolicyAction(PyBundle.message("debugger.variables.loading.asynchronously.text", new Object[0]), PyBundle.message("debugger.variables.loading.asynchronously.description", new Object[0]), ValuesPolicy.ASYNC, this), new VariablePolicyAction(PyBundle.message("debugger.variables.loading.on.demand.text", new Object[0]), PyBundle.message("debugger.variables.loading.on.demand.description", new Object[0]), ValuesPolicy.ON_DEMAND, this)});
        }

        protected ValuesPolicy getDebuggerPolicy() {
            return PyDebuggerSettings.getInstance().getValuesPolicy();
        }
    }

    public static class VariablePolicyAction
    extends AbstractPolicyAction<ValuesPolicy, VariablesPolicyGroup> {
        public VariablePolicyAction(@Nls @NotNull String text, @Nls @NotNull String description, @NotNull ValuesPolicy policy, @NotNull VariablesPolicyGroup actionGroup) {
            if (text == null) {
                VariablePolicyAction.$$$reportNull$$$0(0);
            }
            if (description == null) {
                VariablePolicyAction.$$$reportNull$$$0(1);
            }
            if (policy == null) {
                VariablePolicyAction.$$$reportNull$$$0(2);
            }
            if (actionGroup == null) {
                VariablePolicyAction.$$$reportNull$$$0(3);
            }
            super(text, description, policy, actionGroup);
        }

        @Override
        protected void changeDebuggerSettings() {
            PyDebuggerSettings.getInstance().setValuesPolicy((ValuesPolicy)this.getPolicy());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "description";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "policy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "actionGroup";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/PyVariableViewSettings$VariablePolicyAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class SimplifiedView
    extends ToggleAction {
        private final PyDebugProcess myProcess;
        private volatile boolean mySimplifiedView = PyDebuggerSettings.getInstance().isSimplifiedView();

        public SimplifiedView(@Nullable PyDebugProcess debugProcess) {
            super(PyBundle.message("debugger.simplified.view.text", new Object[0]), PyBundle.message("debugger.simplified.view.description", new Object[0]), null);
            this.myProcess = debugProcess;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(0);
            }
            super.update(e);
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(true);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                SimplifiedView.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(2);
            }
            return this.mySimplifiedView;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean hide) {
            if (e == null) {
                SimplifiedView.$$$reportNull$$$0(3);
            }
            this.mySimplifiedView = hide;
            PyDebuggerSettings.getInstance().setSimplifiedView(hide);
            if (this.myProcess != null) {
                this.myProcess.getSession().rebuildViews();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/debugger/PyVariableViewSettings$SimplifiedView";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/debugger/PyVariableViewSettings$SimplifiedView";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

