/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jna;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.system.OS;
import com.sun.jna.Native;
import org.jetbrains.annotations.NotNull;

public final class JnaLoader {
    private static Boolean ourJnaLoaded = null;

    public static synchronized void load(@NotNull Logger logger) {
        if (logger == null) {
            JnaLoader.$$$reportNull$$$0(0);
        }
        if (ourJnaLoaded == null) {
            String winDir;
            ourJnaLoaded = Boolean.FALSE;
            OS os = OS.CURRENT;
            if (os == OS.Windows && Boolean.getBoolean("ide.native.launcher") && (winDir = System.getenv("SystemRoot")) != null) {
                String path = System.getProperty("jna.platform.library.path");
                path = (path == null ? "" : path + ';') + winDir + "\\System32";
                System.setProperty("jna.platform.library.path", path);
            }
            try {
                long t = System.currentTimeMillis();
                int ptrSize = Native.POINTER_SIZE;
                t = System.currentTimeMillis() - t;
                logger.info("JNA library (" + (ptrSize << 3) + "-bit) loaded in " + t + " ms");
                ourJnaLoaded = Boolean.TRUE;
            }
            catch (Throwable t) {
                logger.warn("Unable to load JNA library (" + (Object)((Object)os) + '/' + os.version() + ", jna.boot.library.path=" + System.getProperty("jna.boot.library.path") + ')', t);
            }
        }
    }

    public static synchronized boolean isLoaded() {
        if (ourJnaLoaded == null) {
            JnaLoader.load(Logger.getInstance(JnaLoader.class));
        }
        return ourJnaLoaded;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logger", "com/intellij/jna/JnaLoader", "load"));
    }
}

