/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.repo.RepositoryManager;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.GitTag;
import git4idea.GitUtil;
import git4idea.branch.GitNewBranchDialog;
import git4idea.branch.GitNewBranchOptions;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRefUtil;
import git4idea.repo.GitRepoInfo;
import git4idea.repo.GitRepository;
import git4idea.ui.branch.GitBranchActionsUtilKt;
import git4idea.ui.branch.GitMultiRootBranchConfig;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchUtil {
    private static final Logger LOG = Logger.getInstance(GitBranchUtil.class);
    private static final String NO_BRANCH_NAME = "(no branch)";

    private GitBranchUtil() {
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForBranch(@NotNull GitRepository repository2, @NotNull GitLocalBranch branch) {
        if (repository2 == null) {
            GitBranchUtil.$$$reportNull$$$0(0);
        }
        if (branch == null) {
            GitBranchUtil.$$$reportNull$$$0(1);
        }
        return GitBranchUtil.getTrackInfo(repository2, branch.getName());
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfo(@NotNull GitRepository repository2, @NotNull @NonNls String localBranchName) {
        if (repository2 == null) {
            GitBranchUtil.$$$reportNull$$$0(2);
        }
        if (localBranchName == null) {
            GitBranchUtil.$$$reportNull$$$0(3);
        }
        return repository2.getBranchTrackInfo(localBranchName);
    }

    @NlsSafe
    @NotNull
    static String getCurrentBranchOrRev(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(4);
        }
        if (repositories.size() > 1) {
            GitMultiRootBranchConfig multiRootBranchConfig = new GitMultiRootBranchConfig(repositories);
            String currentBranch = multiRootBranchConfig.getCurrentBranch();
            LOG.assertTrue(currentBranch != null, (Object)("Repositories have unexpectedly diverged. " + String.valueOf((Object)multiRootBranchConfig)));
            String string = currentBranch;
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(5);
            }
            return string;
        }
        assert (!repositories.isEmpty()) : "No repositories passed to GitBranchOperationsProcessor.";
        GitRepository repository2 = repositories.iterator().next();
        return GitBranchUtil.getBranchNameOrRev(repository2);
    }

    @NotNull
    public static Collection<String> convertBranchesToNames(@NotNull Collection<? extends GitBranch> branches) {
        if (branches == null) {
            GitBranchUtil.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.map(branches, GitReference::getName);
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    public static List<String> getAllTags(@NotNull Project project, @NotNull VirtualFile root) throws VcsException {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(8);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(9);
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.TAG);
        h.addParameters("-l");
        h.setSilent(true);
        h.setEnableInteractiveCallbacks(false);
        final ArrayList<String> tags2 = new ArrayList<String>();
        h.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType != ProcessOutputTypes.STDOUT) {
                    return;
                }
                if (!line.isEmpty()) {
                    tags2.add(line);
                }
            }
        });
        GitCommandResult result2 = Git.getInstance().runCommandWithoutCollectingOutput(h);
        result2.throwOnError(new int[0]);
        ArrayList<String> arrayList = tags2;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getBranchNamesWithoutRemoteHead(@NotNull Collection<? extends GitRemoteBranch> remoteBranches2) {
        if (remoteBranches2 == null) {
            GitBranchUtil.$$$reportNull$$$0(11);
        }
        List list = ContainerUtil.filter(GitBranchUtil.convertBranchesToNames(remoteBranches2), input -> !input.equals("HEAD"));
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(12);
        }
        return list;
    }

    @NlsSafe
    @NotNull
    public static String stripRefsPrefix(@NotNull @NonNls String branchName) {
        if (branchName == null) {
            GitBranchUtil.$$$reportNull$$$0(13);
        }
        String string = com.intellij.vcs.git.ref.GitRefUtil.stripRefsPrefix(branchName);
        if (string == null) {
            GitBranchUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public static String getBranchNameOrRev(@NotNull GitRepository repository2) {
        GitRepoInfo repoInfo;
        if (repository2 == null) {
            GitBranchUtil.$$$reportNull$$$0(15);
        }
        if ((repoInfo = repository2.getInfo()).isOnBranch()) {
            GitLocalBranch currentBranch = repoInfo.getCurrentBranch();
            assert (currentBranch != null);
            String string = currentBranch.getName();
            if (string == null) {
                GitBranchUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        String currentRevision = repoInfo.getCurrentRevision();
        return currentRevision != null ? currentRevision.substring(0, 7) : "";
    }

    @Nullable
    public static GitNewBranchOptions getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable @NlsSafe String initialName) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(17);
        }
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(18);
        }
        if (dialogTitle == null) {
            GitBranchUtil.$$$reportNull$$$0(19);
        }
        return GitBranchUtil.getNewBranchNameFromUser(project, repositories, dialogTitle, initialName, false);
    }

    @Nullable
    public static GitNewBranchOptions getNewBranchNameFromUser(@NotNull Project project, @NotNull Collection<? extends GitRepository> repositories, @NlsContexts.DialogTitle @NotNull String dialogTitle, @Nullable @NlsSafe String initialName, boolean showTrackingOption) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(20);
        }
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(21);
        }
        if (dialogTitle == null) {
            GitBranchUtil.$$$reportNull$$$0(22);
        }
        return new GitNewBranchDialog(project, repositories, dialogTitle, initialName, true, false, showTrackingOption).showAndGetOptions();
    }

    @Nls
    @NotNull
    public static String getDisplayableBranchText(@NotNull GitRepository repository2) {
        if (repository2 == null) {
            GitBranchUtil.$$$reportNull$$$0(23);
        }
        return GitBranchUtil.getDisplayableBranchText(repository2, Function.identity());
    }

    @Nls
    @NotNull
    public static String getDisplayableBranchText(@NotNull GitRepository repository2, @NotNull @NotNull Function<@NotNull @NlsSafe String, @NotNull @NlsSafe String> branchNameTruncator) {
        String branchName;
        Repository.State state2;
        if (repository2 == null) {
            GitBranchUtil.$$$reportNull$$$0(24);
        }
        if (branchNameTruncator == null) {
            GitBranchUtil.$$$reportNull$$$0(25);
        }
        if ((state2 = repository2.getState()) == Repository.State.DETACHED) {
            String detachedStatePresentableText = GitBranchUtil.getDetachedStatePresentableText(repository2, branchNameTruncator);
            return detachedStatePresentableText != null ? detachedStatePresentableText : "";
        }
        GitLocalBranch branch = repository2.getCurrentBranch();
        String string = branchName = branch == null ? "" : branchNameTruncator.apply(branch.getName());
        if (state2 == Repository.State.MERGING) {
            String string2 = GitBundle.message("git.status.bar.widget.text.merge", branchName);
            if (string2 == null) {
                GitBranchUtil.$$$reportNull$$$0(26);
            }
            return string2;
        }
        if (state2 == Repository.State.REBASING) {
            String string3 = GitBundle.message("git.status.bar.widget.text.rebase", branchName);
            if (string3 == null) {
                GitBranchUtil.$$$reportNull$$$0(27);
            }
            return string3;
        }
        if (state2 == Repository.State.GRAFTING) {
            String string4 = GitBundle.message("git.status.bar.widget.text.cherry.pick", branchName);
            if (string4 == null) {
                GitBranchUtil.$$$reportNull$$$0(28);
            }
            return string4;
        }
        if (state2 == Repository.State.REVERTING) {
            String string5 = GitBundle.message("git.status.bar.widget.text.revert", branchName);
            if (string5 == null) {
                GitBranchUtil.$$$reportNull$$$0(29);
            }
            return string5;
        }
        String string6 = branchName;
        if (string6 == null) {
            GitBranchUtil.$$$reportNull$$$0(30);
        }
        return string6;
    }

    @Nls
    private static String getDetachedStatePresentableText(@NotNull GitRepository repository2, @NotNull @NotNull Function<@NotNull @NlsSafe String, @NotNull @NlsSafe String> branchNameTruncator) {
        GitReference currentReference;
        if (repository2 == null) {
            GitBranchUtil.$$$reportNull$$$0(31);
        }
        if (branchNameTruncator == null) {
            GitBranchUtil.$$$reportNull$$$0(32);
        }
        if ((currentReference = GitRefUtil.getCurrentReference(repository2)) instanceof GitTag) {
            return branchNameTruncator.apply(currentReference.getName());
        }
        String currentRevision = repository2.getCurrentRevision();
        if (currentRevision != null) {
            return DvcsUtil.getShortHash((String)currentRevision);
        }
        LOG.warn(String.format("Current revision is null in DETACHED state. isFresh: %s", repository2.isFresh()));
        return GitBundle.message("git.status.bar.widget.text.unknown", new Object[0]);
    }

    @Deprecated
    @RequiresEdt
    @Nullable
    public static GitRepository getCurrentRepository(@NotNull Project project) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(33);
        }
        return GitBranchUtil.getRepositoryOrGuess(project, DvcsUtil.getSelectedFile((Project)project));
    }

    @Deprecated
    @Nullable
    public static GitRepository getRepositoryOrGuess(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(34);
        }
        if (project.isDisposed()) {
            return null;
        }
        return (GitRepository)DvcsUtil.guessRepositoryForFile((Project)project, (RepositoryManager)GitUtil.getRepositoryManager(project), (VirtualFile)file, (String)GitVcsSettings.getInstance(project).getRecentRootPath());
    }

    @Nullable
    public static GitRepository guessRepositoryForOperation(@NotNull Project project, @NotNull DataContext dataContext) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(35);
        }
        if (dataContext == null) {
            GitBranchUtil.$$$reportNull$$$0(36);
        }
        return (GitRepository)DvcsUtil.guessRepositoryForOperation((Project)project, (AbstractRepositoryManager)GitUtil.getRepositoryManager(project), (DataContext)dataContext);
    }

    @Nullable
    public static GitRepository guessWidgetRepository(@NotNull Project project, @Nullable VirtualFile selectedFile) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(37);
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        return (GitRepository)DvcsUtil.guessWidgetRepository((Project)project, (AbstractRepositoryManager)GitUtil.getRepositoryManager(project), (String)settings.getRecentRootPath(), (VirtualFile)selectedFile);
    }

    @Nullable
    public static GitRepository guessWidgetRepository(@NotNull Project project, @NotNull DataContext dataContext) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(38);
        }
        if (dataContext == null) {
            GitBranchUtil.$$$reportNull$$$0(39);
        }
        GitVcsSettings settings = GitVcsSettings.getInstance(project);
        return (GitRepository)DvcsUtil.guessWidgetRepository((Project)project, (AbstractRepositoryManager)GitUtil.getRepositoryManager(project), (String)settings.getRecentRootPath(), (DataContext)dataContext);
    }

    @NotNull
    public static Collection<String> getCommonBranches(Collection<? extends GitRepository> repositories, boolean local) {
        Collection<String> names = local ? GitBranchUtil.convertBranchesToNames(GitBranchUtil.getCommonLocalBranches(repositories)) : GitBranchUtil.getBranchNamesWithoutRemoteHead(GitBranchUtil.getCommonRemoteBranches(repositories));
        List list = ((StreamEx)StreamEx.of(names).sorted(StringUtil::naturalCompare)).toList();
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(40);
        }
        return list;
    }

    @NotNull
    public static List<GitLocalBranch> getCommonLocalBranches(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(41);
        }
        return GitBranchUtil.collectCommon(repositories.stream().map(repository2 -> repository2.getBranches().getLocalBranches()));
    }

    @NotNull
    public static List<GitRemoteBranch> getCommonRemoteBranches(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(42);
        }
        return GitBranchUtil.collectCommon(repositories.stream().map(repository2 -> repository2.getBranches().getRemoteBranches()));
    }

    @NotNull
    public static List<GitTag> getCommonTags(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(43);
        }
        return GitBranchUtil.collectCommon(repositories.stream().map(repository2 -> repository2.getTagHolder().getTags().keySet()));
    }

    @NotNull
    public static <T> List<T> collectCommon(@NotNull Stream<? extends Collection<T>> groups) {
        if (groups == null) {
            GitBranchUtil.$$$reportNull$$$0(44);
        }
        return GitBranchUtil.collectCommon(groups, null);
    }

    @NotNull
    public static <T> List<T> collectCommon(@NotNull Stream<? extends Collection<T>> groups, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable Hash.Strategy<? super T> hashingStrategy) {
        if (groups == null) {
            GitBranchUtil.$$$reportNull$$$0(45);
        }
        ArrayList common = new ArrayList();
        boolean[] firstGroup = new boolean[]{true};
        groups.forEach(values -> {
            if (firstGroup[0]) {
                firstGroup[0] = false;
                common.addAll(values);
            } else {
                HashSet c = hashingStrategy == null ? new HashSet(values) : new ObjectOpenCustomHashSet(values, hashingStrategy);
                common.retainAll(c);
            }
        });
        ArrayList arrayList = common;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(46);
        }
        return arrayList;
    }

    @NotNull
    public static <T extends GitReference> List<T> sortBranchesByName(@NotNull Collection<? extends T> branches) {
        if (branches == null) {
            GitBranchUtil.$$$reportNull$$$0(47);
        }
        List list = branches.stream().sorted(Comparator.comparing(GitReference::getFullName, NaturalComparator.INSTANCE)).collect(Collectors.toList());
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(48);
        }
        return list;
    }

    @NotNull
    public static List<String> sortBranchNames(@NotNull Collection<String> branchNames) {
        if (branchNames == null) {
            GitBranchUtil.$$$reportNull$$$0(49);
        }
        List list = ContainerUtil.sorted(branchNames, (Comparator)NaturalComparator.INSTANCE);
        if (list == null) {
            GitBranchUtil.$$$reportNull$$$0(50);
        }
        return list;
    }

    @RequiresBackgroundThread
    @NotNull
    public static Collection<String> getBranches(@NotNull Project project, @NotNull VirtualFile root, boolean localWanted, boolean remoteWanted, @Nullable String containingCommit) throws VcsException {
        String[] split;
        String output2;
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(51);
        }
        if (root == null) {
            GitBranchUtil.$$$reportNull$$$0(52);
        }
        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.BRANCH);
        handler.setSilent(true);
        handler.addParameters("--no-color");
        boolean remoteOnly = false;
        if (remoteWanted && localWanted) {
            handler.addParameters("-a");
            remoteOnly = false;
        } else if (remoteWanted) {
            handler.addParameters("-r");
            remoteOnly = true;
        }
        if (containingCommit != null) {
            handler.addParameters("--contains", containingCommit);
        }
        if ((output2 = Git.getInstance().runCommand(handler).getOutputOrThrow(new int[0])).trim().isEmpty()) {
            List<String> list;
            try {
                File headFile = GitUtil.getRepositoryForRoot(project, root).getRepositoryFiles().getHeadFile();
                String head = FileUtil.loadFile((File)headFile, (Charset)StandardCharsets.UTF_8).trim();
                String prefix = "ref: refs/heads/";
                list = head.startsWith("ref: refs/heads/") ? Collections.singletonList(head.substring("ref: refs/heads/".length())) : Collections.emptyList();
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    GitBranchUtil.$$$reportNull$$$0(54);
                }
                return list2;
            }
            if (list == null) {
                GitBranchUtil.$$$reportNull$$$0(53);
            }
            return list;
        }
        ArrayList<String> branches = new ArrayList<String>();
        for (String b : split = output2.split("\n")) {
            boolean isRemote;
            if ((b = b.substring(2).trim()).equals(NO_BRANCH_NAME)) continue;
            String remotePrefix = null;
            if (b.startsWith("remotes/")) {
                remotePrefix = "remotes/";
            } else if (b.startsWith("refs/remotes/")) {
                remotePrefix = "refs/remotes/";
            }
            boolean bl = isRemote = remotePrefix != null || remoteOnly;
            if (isRemote) {
                int idx;
                if (!remoteOnly) {
                    b = b.substring(remotePrefix.length());
                }
                if ((idx = b.indexOf("HEAD ->")) > 0) continue;
            }
            branches.add(b);
        }
        ArrayList<String> arrayList = branches;
        if (arrayList == null) {
            GitBranchUtil.$$$reportNull$$$0(55);
        }
        return arrayList;
    }

    public static boolean equalBranches(@Nullable @NonNls String branchA, @Nullable @NonNls String branchB) {
        return StringUtilRt.equal((CharSequence)branchA, (CharSequence)branchB, (boolean)SystemInfo.isFileSystemCaseSensitive);
    }

    public static void updateBranches(@NotNull Project project, @NotNull List<? extends GitRepository> repositories, @NotNull List<String> localBranchNames) {
        if (project == null) {
            GitBranchUtil.$$$reportNull$$$0(56);
        }
        if (repositories == null) {
            GitBranchUtil.$$$reportNull$$$0(57);
        }
        if (localBranchNames == null) {
            GitBranchUtil.$$$reportNull$$$0(58);
        }
        GitBranchActionsUtilKt.updateBranches(project, repositories, localBranchNames);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 10, 12, 14, 16, 26, 27, 28, 29, 30, 40, 46, 48, 50, 53, 54, 55 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchName";
                break;
            }
            case 4: 
            case 18: 
            case 21: 
            case 41: 
            case 42: 
            case 43: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 40: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchUtil";
                break;
            }
            case 6: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
            case 8: 
            case 17: 
            case 20: 
            case 33: 
            case 34: 
            case 35: 
            case 37: 
            case 38: 
            case 51: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchName";
                break;
            }
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogTitle";
                break;
            }
            case 25: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNameTruncator";
                break;
            }
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branchNames";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranchNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentBranchOrRev";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "convertBranchesToNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTags";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNamesWithoutRemoteHead";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "stripRefsPrefix";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranchNameOrRev";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayableBranchText";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonBranches";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommon";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "sortBranchesByName";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "sortBranchNames";
                break;
            }
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfoForBranch";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getTrackInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentBranchOrRev";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 40: 
            case 46: 
            case 48: 
            case 50: 
            case 53: 
            case 54: 
            case 55: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertBranchesToNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAllTags";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNamesWithoutRemoteHead";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "stripRefsPrefix";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getBranchNameOrRev";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNewBranchNameFromUser";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayableBranchText";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getDetachedStatePresentableText";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentRepository";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getRepositoryOrGuess";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "guessRepositoryForOperation";
                break;
            }
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "guessWidgetRepository";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCommonLocalBranches";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getCommonRemoteBranches";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getCommonTags";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "collectCommon";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "sortBranchesByName";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "sortBranchNames";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getBranches";
                break;
            }
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "updateBranches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 10, 12, 14, 16, 26, 27, 28, 29, 30, 40, 46, 48, 50, 53, 54, 55 -> new IllegalStateException(string);
        };
    }
}

