/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.actions.column;

import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.editor.tables.TableUtils;
import org.intellij.plugins.markdown.editor.tables.actions.TableActionKeys;
import org.intellij.plugins.markdown.lang.MarkdownLanguageUtilsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H$J)\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014\u00a2\u0006\u0002\u0010\u0012J8\u0010\u0013\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\"\u0010\u001a\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0014J'\u0010\u001b\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0011H\u0014\u00a2\u0006\u0002\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "performAction", "editor", "Lcom/intellij/openapi/editor/Editor;", "table", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "columnIndex", "", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;Ljava/lang/Integer;)V", "findTableAndIndex", "Lkotlin/Pair;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "findTable", "findColumnIndex", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Document;I)Ljava/lang/Integer;", "Companion", "intellij.markdown"})
public abstract class ColumnBasedTableAction
extends AnAction {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        if (caret == null) {
            return;
        }
        int offset = caret.getOffset();
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, Integer> pair = this.findTableAndIndex(event, file, document2, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        if (table == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (columnIndex == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.performAction(editor3, table, columnIndex);
    }

    public void update(@NotNull AnActionEvent event) {
        Integer offset;
        PsiFile file;
        Editor editor2;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Project project = (Project)event.getData(CommonDataKeys.PROJECT);
                editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
                file = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
                Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
                Integer n = offset = caret != null ? Integer.valueOf(caret.getOffset()) : null;
                if (project == null || editor2 == null || file == null || offset == null) break block2;
                Language language = file.getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
                if (MarkdownLanguageUtilsKt.isMarkdownLanguage(language)) break block3;
            }
            event.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        Pair<MarkdownTable, Integer> pair = this.findTableAndIndex(event, file, document2, offset);
        MarkdownTable table = (MarkdownTable)pair.component1();
        Integer columnIndex = (Integer)pair.component2();
        event.getPresentation().setEnabledAndVisible(table != null && columnIndex != null);
        this.update(event, table, columnIndex);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected abstract void performAction(@NotNull Editor var1, @NotNull MarkdownTable var2, int var3);

    protected void update(@NotNull AnActionEvent event, @Nullable MarkdownTable table, @Nullable Integer columnIndex) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
    }

    private final Pair<MarkdownTable, Integer> findTableAndIndex(AnActionEvent event, PsiFile file, Document document, int offset) {
        return Companion.findTableAndIndex(event, file, document, offset, (Function3<? super PsiFile, ? super Document, ? super Integer, ? extends MarkdownTable>)((Function3)new Function3<PsiFile, Document, Integer, MarkdownTable>((Object)this){

            public final MarkdownTable invoke(PsiFile p0, Document p1, int p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ColumnBasedTableAction)((Object)this.receiver)).findTable(p0, p1, p2);
            }
        }), (Function3<? super PsiFile, ? super Document, ? super Integer, Integer>)((Function3)new Function3<PsiFile, Document, Integer, Integer>((Object)this){

            public final Integer invoke(PsiFile p0, Document p1, int p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((ColumnBasedTableAction)((Object)this.receiver)).findColumnIndex(p0, p1, p2);
            }
        }));
    }

    @Nullable
    protected MarkdownTable findTable(@NotNull PsiFile file, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return TableUtils.findTable(file, offset);
    }

    @Nullable
    protected Integer findColumnIndex(@NotNull PsiFile file, @NotNull Document document, int offset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return TableUtils.findCellIndex(file, offset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jz\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072 \u0010\u000f\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00102 \u0010\u0011\u001a\u001c\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0010J6\u0010\u0004\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007\u00a8\u0006\u0012"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction$Companion;", "", "<init>", "()V", "findTableAndIndex", "Lkotlin/Pair;", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownTable;", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "tableGetter", "Lkotlin/Function3;", "columnIndexGetter", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nColumnBasedTableAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnBasedTableAction.kt\norg/intellij/plugins/markdown/editor/tables/actions/column/ColumnBasedTableAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,111:1\n1#2:112\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pair<MarkdownTable, Integer> findTableAndIndex(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Document document, int offset, @NotNull Function3<? super PsiFile, ? super Document, ? super Integer, ? extends MarkdownTable> tableGetter, @NotNull Function3<? super PsiFile, ? super Document, ? super Integer, Integer> columnIndexGetter) {
            MarkdownTable markdownTable;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter(tableGetter, (String)"tableGetter");
            Intrinsics.checkNotNullParameter(columnIndexGetter, (String)"columnIndexGetter");
            WeakReference weakReference = (WeakReference)event.getData(TableActionKeys.INSTANCE.getELEMENT());
            PsiElement psiElement = weakReference != null ? (PsiElement)weakReference.get() : null;
            MarkdownTable tableFromEvent = psiElement instanceof MarkdownTable ? (MarkdownTable)psiElement : null;
            Integer indexFromEvent = (Integer)event.getData(TableActionKeys.INSTANCE.getCOLUMN_INDEX());
            if (tableFromEvent != null && indexFromEvent != null) {
                return TuplesKt.to((Object)tableFromEvent, (Object)indexFromEvent);
            }
            MarkdownTable markdownTable2 = (MarkdownTable)tableGetter.invoke((Object)file, (Object)document, (Object)offset);
            if (markdownTable2 != null) {
                MarkdownTable markdownTable3;
                MarkdownTable it = markdownTable3 = markdownTable2;
                boolean bl = false;
                markdownTable = it.isValid() ? markdownTable3 : null;
            } else {
                markdownTable = null;
            }
            MarkdownTable table = markdownTable;
            Integer index = (Integer)columnIndexGetter.invoke((Object)file, (Object)document, (Object)offset);
            return TuplesKt.to((Object)table, (Object)index);
        }

        @NotNull
        public final Pair<MarkdownTable, Integer> findTableAndIndex(@NotNull AnActionEvent event, @NotNull PsiFile file, @NotNull Document document, int offset) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return this.findTableAndIndex(event, file, document, offset, (Function3<? super PsiFile, ? super Document, ? super Integer, ? extends MarkdownTable>)((Function3)Companion::findTableAndIndex$lambda$1), (Function3<? super PsiFile, ? super Document, ? super Integer, Integer>)((Function3)Companion::findTableAndIndex$lambda$2));
        }

        private static final MarkdownTable findTableAndIndex$lambda$1(PsiFile file, Document document, int offset) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return TableUtils.findTable(file, offset);
        }

        private static final Integer findTableAndIndex$lambda$2(PsiFile file, Document document, int offset) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return TableUtils.findCellIndex(file, offset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

