/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.log;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgBundle;
import org.zmlx.hg4idea.HgChange;
import org.zmlx.hg4idea.HgContentRevision;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgFileRevision;
import org.zmlx.hg4idea.HgFileStatusEnum;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.command.HgLogCommand;
import org.zmlx.hg4idea.command.HgStatusCommand;
import org.zmlx.hg4idea.execution.HgCommandResult;
import org.zmlx.hg4idea.execution.HgLineProcessListener;
import org.zmlx.hg4idea.log.HgBaseLogParser;
import org.zmlx.hg4idea.log.HgChangesParser;
import org.zmlx.hg4idea.log.HgFileRevisionLogParser;
import org.zmlx.hg4idea.util.HgChangesetUtil;
import org.zmlx.hg4idea.util.HgUtil;
import org.zmlx.hg4idea.util.HgVersion;

public final class HgHistoryUtil {
    private static final Logger LOG = Logger.getInstance(HgHistoryUtil.class);

    private HgHistoryUtil() {
    }

    @NotNull
    public static List<VcsCommitMetadata> loadMetadata(@NotNull Project project, @NotNull VirtualFile root, int limit, @NotNull List<String> parameters) {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(2);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List<VcsCommitMetadata> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(3);
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtilRt.toStringArray(templateList);
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, limit, parameters, HgChangesetUtil.makeTemplate(templates));
        HgBaseLogParser<VcsCommitMetadata> baseParser = HgHistoryUtil.createMetadataParser(root, factory);
        return HgHistoryUtil.getCommitRecords(project, result, baseParser);
    }

    @NotNull
    public static List<VcsFullCommitDetails> history(@NotNull Project project, @NotNull VirtualFile root, int limit, @NotNull List<@NonNls String> hashParameters, boolean silent) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(4);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(5);
        }
        if (hashParameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(6);
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = HgBaseLogParser.constructFullTemplateArgument(true, version);
        ArrayList<VcsFullCommitDetails> result = new ArrayList<VcsFullCommitDetails>();
        VcsLogObjectsFactory factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<VcsFullCommitDetails> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(7);
            }
            return list;
        }
        HgFileRevisionLogParser parser = new HgFileRevisionLogParser(project, HgHistoryUtil.getOriginalHgFile(project, root), hgvcs.getVersion());
        try {
            HgHistoryUtil.readLog(project, root, hgvcs.getVersion(), limit, hashParameters, HgChangesetUtil.makeTemplate(templates), (Consumer<? super StringBuilder>)((Consumer)stringBuilder -> {
                HgFileRevision revision = (HgFileRevision)parser.convert(stringBuilder.toString());
                if (revision != null) {
                    result.add(HgHistoryUtil.createDetails(project, root, factory, revision));
                }
            }));
        }
        catch (VcsException e) {
            if (!silent) {
                VcsNotifier.getInstance((Project)project).notifyError("hg.log.command.execution.error", HgBundle.message("hg4idea.error.log.command.execution", new Object[0]), e.getMessage());
            }
            throw e;
        }
        ArrayList<VcsFullCommitDetails> arrayList = result;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public static List<? extends VcsFullCommitDetails> createFullCommitsFromResult(@NotNull Project project, @NotNull VirtualFile root, @Nullable HgCommandResult result, @NotNull HgVersion version) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(9);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(10);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(11);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<HgFileRevision> hgRevisions = HgHistoryUtil.getCommitRecordsOrFail(project, result, new HgFileRevisionLogParser(project, HgHistoryUtil.getOriginalHgFile(project, root), version));
        ArrayList<VcsFullCommitDetails> vcsFullCommitDetailsList = new ArrayList<VcsFullCommitDetails>();
        for (HgFileRevision revision : hgRevisions) {
            vcsFullCommitDetailsList.add(HgHistoryUtil.createDetails(project, root, factory, revision));
        }
        ArrayList<VcsFullCommitDetails> arrayList = vcsFullCommitDetailsList;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    public static VcsFullCommitDetails createDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull VcsLogObjectsFactory factory, @NotNull HgFileRevision revision) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(14);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(15);
        }
        if (factory == null) {
            HgHistoryUtil.$$$reportNull$$$0(16);
        }
        if (revision == null) {
            HgHistoryUtil.$$$reportNull$$$0(17);
        }
        ArrayList<List<VcsFileStatusInfo>> reportedChanges = new ArrayList<List<VcsFileStatusInfo>>();
        reportedChanges.add(HgHistoryUtil.getStatusInfo(revision));
        HgRevisionNumber vcsRevisionNumber = revision.getRevisionNumber();
        List<? extends HgRevisionNumber> parents = vcsRevisionNumber.getParents();
        for (HgRevisionNumber parent : parents.stream().skip(1L).toList()) {
            reportedChanges.add(HgHistoryUtil.getChangesFromParent(project, root, vcsRevisionNumber, parent));
        }
        Hash hash = factory.createHash(vcsRevisionNumber.getChangeset());
        List parentsHashes = ContainerUtil.map(parents, p -> factory.createHash(p.getChangeset()));
        long time = revision.getRevisionDate().getTime();
        VcsUser author = factory.createUser(vcsRevisionNumber.getName(), vcsRevisionNumber.getEmail());
        return new VcsChangesLazilyParsedDetails(project, hash, parentsHashes, time, root, vcsRevisionNumber.getSubject(), author, vcsRevisionNumber.getCommitMessage(), author, time, reportedChanges, (VcsChangesLazilyParsedDetails.ChangesParser)new HgChangesParser(vcsRevisionNumber));
    }

    @NotNull
    private static List<VcsFileStatusInfo> getChangesFromParent(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgRevisionNumber commit, @NotNull HgRevisionNumber parent) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(18);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(19);
        }
        if (commit == null) {
            HgHistoryUtil.$$$reportNull$$$0(20);
        }
        if (parent == null) {
            HgHistoryUtil.$$$reportNull$$$0(21);
        }
        HgStatusCommand status = new HgStatusCommand.Builder(true).ignored(false).unknown(false).copySource(true).baseRevision(parent).targetRevision(commit).build(project);
        return HgHistoryUtil.convertHgChanges(status.executeInCurrentThread(root));
    }

    @NotNull
    private static List<VcsFileStatusInfo> getStatusInfo(@NotNull HgFileRevision revision) {
        if (revision == null) {
            HgHistoryUtil.$$$reportNull$$$0(22);
        }
        ArrayList<VcsFileStatusInfo> firstParentChanges = new ArrayList<VcsFileStatusInfo>();
        for (String string : revision.getModifiedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.MODIFICATION, string, null));
        }
        for (String string : revision.getAddedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.NEW, string, null));
        }
        for (String string : revision.getDeletedFiles()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.DELETED, string, null));
        }
        for (Map.Entry entry : revision.getMovedFiles().entrySet()) {
            firstParentChanges.add(new VcsFileStatusInfo(Change.Type.MOVED, (String)entry.getKey(), (String)entry.getValue()));
        }
        ArrayList<VcsFileStatusInfo> arrayList = firstParentChanges;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(23);
        }
        return arrayList;
    }

    @NotNull
    private static List<VcsFileStatusInfo> convertHgChanges(@NotNull Set<HgChange> changes) {
        if (changes == null) {
            HgHistoryUtil.$$$reportNull$$$0(24);
        }
        HashSet<String> deleted = new HashSet<String>();
        HashSet<String> copied = new HashSet<String>();
        for (HgChange change : changes) {
            Change.Type type = HgHistoryUtil.getType(change.getStatus());
            if (Change.Type.DELETED.equals((Object)type)) {
                deleted.add(change.beforeFile().getRelativePath());
                continue;
            }
            if (!Change.Type.MOVED.equals((Object)type)) continue;
            copied.add(change.beforeFile().getRelativePath());
        }
        ArrayList<VcsFileStatusInfo> result = new ArrayList<VcsFileStatusInfo>();
        block5: for (HgChange change : changes) {
            String secondPath;
            String firstPath;
            Change.Type type = HgHistoryUtil.getType(change.getStatus());
            LOG.assertTrue(type != null, (Object)("Unsupported status for change " + String.valueOf(change)));
            switch (type) {
                case DELETED: {
                    firstPath = change.beforeFile().getRelativePath();
                    secondPath = null;
                    if (!copied.contains(firstPath)) break;
                    continue block5;
                }
                case MOVED: {
                    firstPath = change.beforeFile().getRelativePath();
                    secondPath = change.afterFile().getRelativePath();
                    if (deleted.contains(firstPath)) break;
                    type = Change.Type.NEW;
                    firstPath = change.afterFile().getRelativePath();
                    secondPath = null;
                    break;
                }
                default: {
                    firstPath = change.afterFile().getRelativePath();
                    secondPath = null;
                }
            }
            result.add(new VcsFileStatusInfo(type, Objects.requireNonNull(firstPath), secondPath));
        }
        ArrayList<VcsFileStatusInfo> arrayList = result;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    private static Change.Type getType(@NotNull HgFileStatusEnum status) {
        if (status == null) {
            HgHistoryUtil.$$$reportNull$$$0(26);
        }
        return switch (status) {
            default -> throw new MatchException(null, null);
            case HgFileStatusEnum.ADDED -> Change.Type.NEW;
            case HgFileStatusEnum.MODIFIED -> Change.Type.MODIFICATION;
            case HgFileStatusEnum.DELETED -> Change.Type.DELETED;
            case HgFileStatusEnum.COPY -> Change.Type.MOVED;
            case HgFileStatusEnum.UNVERSIONED, HgFileStatusEnum.MISSING, HgFileStatusEnum.UNMODIFIED, HgFileStatusEnum.IGNORED -> null;
        };
    }

    @Nullable
    public static HgCommandResult getLogResult(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgVersion version, int limit, @NotNull List<String> parameters, @NotNull String template) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(27);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(28);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(29);
        }
        if (parameters == null) {
            HgHistoryUtil.$$$reportNull$$$0(30);
        }
        if (template == null) {
            HgHistoryUtil.$$$reportNull$$$0(31);
        }
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        ArrayList<String> args = new ArrayList<String>(parameters);
        if (!version.isParentRevisionTemplateSupported()) {
            args.add("--debug");
        }
        return hgLogCommand.execute(root, template, limit, HgHistoryUtil.getOriginalHgFile(project, root), args);
    }

    public static void readLog(@NotNull Project project, @NotNull VirtualFile root, @NotNull HgVersion version, int limit, @NotNull List<String> hashes, @NotNull String template, @NotNull Consumer<? super StringBuilder> consumer) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(32);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(33);
        }
        if (version == null) {
            HgHistoryUtil.$$$reportNull$$$0(34);
        }
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(35);
        }
        if (template == null) {
            HgHistoryUtil.$$$reportNull$$$0(36);
        }
        if (consumer == null) {
            HgHistoryUtil.$$$reportNull$$$0(37);
        }
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        ThrowableConsumer logRunner = hashesChunk -> {
            HgLogOutputSplitter splitter = new HgLogOutputSplitter(consumer);
            ArrayList<String> args = new ArrayList<String>((Collection<String>)hashesChunk);
            if (!version.isParentRevisionTemplateSupported()) {
                args.add("--debug");
            }
            hgLogCommand.execute(root, template, limit, HgHistoryUtil.getOriginalHgFile(project, root), args, splitter);
            splitter.finish();
        };
        if (hashes.isEmpty()) {
            logRunner.consume(hashes);
        } else {
            VcsFileUtil.foreachChunk(hashes, (int)2, (ThrowableConsumer)logRunner);
        }
    }

    public static HgFile getOriginalHgFile(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(38);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(39);
        }
        HgFile hgFile = new HgFile(root, VcsUtil.getFilePath((String)root.getPath()));
        if (project.isDisposed()) {
            return hgFile;
        }
        FilePath originalFileName = HgUtil.getOriginalFileName(hgFile.toFilePath(), ChangeListManager.getInstance((Project)project));
        return new HgFile(hgFile.getRepo(), originalFileName);
    }

    @NotNull
    public static <CommitInfo> List<CommitInfo> getCommitRecords(@NotNull Project project, @Nullable HgCommandResult result, @NotNull Function<? super String, ? extends CommitInfo> converter) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(40);
        }
        if (converter == null) {
            HgHistoryUtil.$$$reportNull$$$0(41);
        }
        try {
            return HgHistoryUtil.getCommitRecordsOrFail(project, result, converter);
        }
        catch (VcsException e) {
            VcsNotifier.getInstance((Project)project).notifyError("hg.log.command.execution.error", HgBundle.message("hg4idea.error.log.command.execution", new Object[0]), e.getMessage());
            List list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(42);
            }
            return list;
        }
    }

    @NotNull
    public static <CommitInfo> List<CommitInfo> getCommitRecordsOrFail(@NotNull Project project, @Nullable HgCommandResult result, @NotNull Function<? super String, ? extends CommitInfo> converter) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(43);
        }
        if (converter == null) {
            HgHistoryUtil.$$$reportNull$$$0(44);
        }
        LinkedList revisions = new LinkedList();
        if (result == null) {
            LinkedList linkedList = revisions;
            if (linkedList == null) {
                HgHistoryUtil.$$$reportNull$$$0(45);
            }
            return linkedList;
        }
        List<@NlsSafe String> errors = result.getErrorLines();
        if (!errors.isEmpty()) {
            if (result.getExitValue() != 0) {
                throw new VcsException(errors.toString());
            }
            LOG.warn(errors.toString());
        }
        String output = result.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        List list = changeSets.stream().map(converter).filter(Objects::nonNull).collect(Collectors.toList());
        if (list == null) {
            HgHistoryUtil.$$$reportNull$$$0(46);
        }
        return list;
    }

    public static void readCommitMetadata(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes, @NotNull Consumer<? super VcsCommitMetadata> consumer) throws VcsException {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(47);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(48);
        }
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(49);
        }
        if (consumer == null) {
            HgHistoryUtil.$$$reportNull$$$0(50);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            return;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        List<String> templateList = HgBaseLogParser.constructDefaultTemplate(version);
        templateList.add("{desc}");
        String[] templates = ArrayUtilRt.toStringArray(templateList);
        HgBaseLogParser<VcsCommitMetadata> parser = HgHistoryUtil.createMetadataParser(root, factory);
        HgHistoryUtil.readLog(project, root, hgvcs.getVersion(), -1, HgHistoryUtil.prepareHashes(hashes), HgChangesetUtil.makeTemplate(templates), (Consumer<? super StringBuilder>)((Consumer)stringBuilder -> {
            VcsCommitMetadata metadata = (VcsCommitMetadata)parser.convert(stringBuilder.toString());
            if (metadata != null) {
                consumer.consume((Object)metadata);
            }
        }));
    }

    @NotNull
    private static HgBaseLogParser<VcsCommitMetadata> createMetadataParser(final @NotNull VirtualFile root, final VcsLogObjectsFactory factory) {
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(51);
        }
        return new HgBaseLogParser<VcsCommitMetadata>(){

            @Override
            protected VcsCommitMetadata convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<? extends HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                if (rev == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (changeset == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (parents == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (revisionDate == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (author == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (email == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (attributes == null) {
                    1.$$$reportNull$$$0(6);
                }
                String message = 1.parseAdditionalStringAttribute(attributes, 5);
                String subject = 1.extractSubject(message);
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                return factory.createCommitMetadata(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime(), root, subject, author, email, message, author, email, revisionDate.getTime());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rev";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changeset";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parents";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "revisionDate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "author";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "email";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "org/zmlx/hg4idea/log/HgHistoryUtil$1";
                objectArray[2] = "convertDetails";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    public static List<TimedVcsCommit> readAllHashes(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<? super VcsUser> userRegistry, @NotNull List<String> params) {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(52);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(53);
        }
        if (userRegistry == null) {
            HgHistoryUtil.$$$reportNull$$$0(54);
        }
        if (params == null) {
            HgHistoryUtil.$$$reportNull$$$0(55);
        }
        return HgHistoryUtil.readHashes(project, root, userRegistry, -1, params);
    }

    @NotNull
    public static List<TimedVcsCommit> readHashes(@NotNull Project project, @NotNull VirtualFile root, final @NotNull Consumer<? super VcsUser> userRegistry, int limit, @NotNull List<String> params) {
        VcsLogObjectsFactory factory;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(56);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(57);
        }
        if (userRegistry == null) {
            HgHistoryUtil.$$$reportNull$$$0(58);
        }
        if (params == null) {
            HgHistoryUtil.$$$reportNull$$$0(59);
        }
        if ((factory = HgHistoryUtil.getObjectsFactoryWithDisposeCheck(project)) == null) {
            List<TimedVcsCommit> list = Collections.emptyList();
            if (list == null) {
                HgHistoryUtil.$$$reportNull$$$0(60);
            }
            return list;
        }
        HgVcs hgvcs = HgVcs.getInstance(project);
        assert (hgvcs != null);
        HgVersion version = hgvcs.getVersion();
        String[] templates = ArrayUtilRt.toStringArray(HgBaseLogParser.constructDefaultTemplate(version));
        HgCommandResult result = HgHistoryUtil.getLogResult(project, root, version, limit, params, HgChangesetUtil.makeTemplate(templates));
        return HgHistoryUtil.getCommitRecords(project, result, new HgBaseLogParser<TimedVcsCommit>(){

            @Override
            protected TimedVcsCommit convertDetails(@NotNull String rev, @NotNull String changeset, @NotNull SmartList<? extends HgRevisionNumber> parents, @NotNull Date revisionDate, @NotNull String author, @NotNull String email, @NotNull List<String> attributes) {
                if (rev == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (changeset == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (parents == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (revisionDate == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (author == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (email == null) {
                    2.$$$reportNull$$$0(5);
                }
                if (attributes == null) {
                    2.$$$reportNull$$$0(6);
                }
                SmartList parentsHash = new SmartList();
                for (HgRevisionNumber parent : parents) {
                    parentsHash.add(factory.createHash(parent.getChangeset()));
                }
                userRegistry.consume((Object)factory.createUser(author, email));
                return factory.createTimedCommit(factory.createHash(changeset), (List)parentsHash, revisionDate.getTime());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "rev";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "changeset";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "parents";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "revisionDate";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[0] = "author";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[0] = "email";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[0] = "attributes";
                        break;
                    }
                }
                objectArray[1] = "org/zmlx/hg4idea/log/HgHistoryUtil$2";
                objectArray[2] = "convertDetails";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(Project project) {
        if (!project.isDisposed()) {
            return (VcsLogObjectsFactory)project.getService(VcsLogObjectsFactory.class);
        }
        return null;
    }

    @NotNull
    public static Change createChange(@NotNull Project project, @NotNull VirtualFile root, @Nullable String fileBefore, @Nullable HgRevisionNumber revisionBefore, @Nullable String fileAfter, HgRevisionNumber revisionAfter, FileStatus aStatus) {
        ContentRevision afterRevision;
        HgContentRevision beforeRevision;
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(61);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(62);
        }
        HgContentRevision hgContentRevision = beforeRevision = fileBefore == null || aStatus == FileStatus.ADDED ? null : HgContentRevision.create(project, new HgFile(root, new File(root.getPath(), fileBefore)), revisionBefore);
        if (aStatus == FileStatus.DELETED) {
            afterRevision = null;
        } else if (revisionAfter == null && fileBefore != null) {
            afterRevision = CurrentContentRevision.create((FilePath)new HgFile(root, new File(root.getPath(), fileAfter != null ? fileAfter : fileBefore)).toFilePath());
        } else {
            assert (revisionAfter != null);
            afterRevision = fileAfter == null ? null : HgContentRevision.create(project, new HgFile(root, new File(root.getPath(), fileAfter)), revisionAfter);
        }
        return new Change(beforeRevision, afterRevision, aStatus);
    }

    @NotNull
    public static List<String> prepareHashes(@NotNull List<String> hashes) {
        if (hashes == null) {
            HgHistoryUtil.$$$reportNull$$$0(63);
        }
        ArrayList<String> hashArgs = new ArrayList<String>();
        for (String hash : hashes) {
            hashArgs.add("-r");
            hashArgs.add(hash);
        }
        ArrayList<String> arrayList = hashArgs;
        if (arrayList == null) {
            HgHistoryUtil.$$$reportNull$$$0(64);
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getDescendingHeadsOfBranches(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash) throws VcsException {
        if (project == null) {
            HgHistoryUtil.$$$reportNull$$$0(65);
        }
        if (root == null) {
            HgHistoryUtil.$$$reportNull$$$0(66);
        }
        if (hash == null) {
            HgHistoryUtil.$$$reportNull$$$0(67);
        }
        HashSet<String> branchHeads = new HashSet<String>();
        ArrayList<String> params = new ArrayList<String>();
        params.add("-r");
        params.add("descendants(" + hash.asString() + ") and head()");
        HgLogCommand hgLogCommand = new HgLogCommand(project);
        hgLogCommand.setLogFile(false);
        String template = HgChangesetUtil.makeTemplate("{branch}", "{bookmarks}");
        HgCommandResult logResult = hgLogCommand.execute(root, template, -1, null, params);
        if (logResult == null || logResult.getExitValue() != 0) {
            throw new VcsException(HgBundle.message("error.history.cant.get.commit.details.log.command.error", new Object[0]));
        }
        String output = logResult.getRawOutput();
        List changeSets = StringUtil.split((String)output, (String)"\u0003");
        for (String line : changeSets) {
            List attributes = StringUtil.split((String)line, (String)"\u0017");
            branchHeads.addAll(attributes);
        }
        HashSet<String> hashSet = branchHeads;
        if (hashSet == null) {
            HgHistoryUtil.$$$reportNull$$$0(68);
        }
        return hashSet;
    }

    public static String prepareParameter(String paramName, String value) {
        return "--" + paramName + "=" + value;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 8, 12, 13, 23, 25, 42, 45, 46, 60, 64, 68 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 15: 
            case 19: 
            case 28: 
            case 33: 
            case 39: 
            case 48: 
            case 51: 
            case 53: 
            case 57: 
            case 62: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 23: 
            case 25: 
            case 42: 
            case 45: 
            case 46: 
            case 60: 
            case 64: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/log/HgHistoryUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashParameters";
                break;
            }
            case 11: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
            case 31: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 35: 
            case 49: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashes";
                break;
            }
            case 37: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 41: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userRegistry";
                break;
            }
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/log/HgHistoryUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMetadata";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "history";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createFullCommitsFromResult";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusInfo";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "convertHgChanges";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitRecords";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitRecordsOrFail";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "readHashes";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareHashes";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendingHeadsOfBranches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadMetadata";
                break;
            }
            case 3: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 23: 
            case 25: 
            case 42: 
            case 45: 
            case 46: 
            case 60: 
            case 64: 
            case 68: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "history";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFullCommitsFromResult";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDetails";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getChangesFromParent";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getStatusInfo";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "convertHgChanges";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getLogResult";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "readLog";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalHgFile";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCommitRecords";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getCommitRecordsOrFail";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "readCommitMetadata";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createMetadataParser";
                break;
            }
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "readAllHashes";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "readHashes";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "prepareHashes";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getDescendingHeadsOfBranches";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 8, 12, 13, 23, 25, 42, 45, 46, 60, 64, 68 -> new IllegalStateException(string);
        };
    }

    private static class HgLogOutputSplitter
    extends HgLineProcessListener {
        @NotNull
        private final StringBuilder myOutput;
        private final Consumer<? super StringBuilder> myConsumer;

        HgLogOutputSplitter(Consumer<? super StringBuilder> consumer) {
            this.myConsumer = consumer;
            this.myOutput = new StringBuilder();
        }

        @Override
        protected void processOutputLine(@NotNull String line) {
            int separatorIndex;
            if (line == null) {
                HgLogOutputSplitter.$$$reportNull$$$0(0);
            }
            while ((separatorIndex = line.indexOf("\u0003")) >= 0) {
                this.myOutput.append(line, 0, separatorIndex);
                this.myConsumer.consume((Object)this.myOutput);
                this.myOutput.setLength(0);
                line = line.substring(separatorIndex + 1);
            }
            this.myOutput.append(line);
        }

        @Override
        public void finish() throws VcsException {
            super.finish();
            if (!this.myOutput.isEmpty()) {
                this.myConsumer.consume((Object)this.myOutput);
                this.myOutput.setLength(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "org/zmlx/hg4idea/log/HgHistoryUtil$HgLogOutputSplitter", "processOutputLine"));
        }
    }
}

