/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis;

import com.intellij.codeInsight.intention.PriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoveAttributeIntentionFix
extends PsiElementBaseIntentionAction
implements LocalQuickFix,
PriorityAction {
    private final String myLocalName;

    public RemoveAttributeIntentionFix(String localName) {
        this.myLocalName = localName;
    }

    public RemoveAttributeIntentionFix() {
        this(null);
    }

    @NotNull
    public String getName() {
        String string = XmlAnalysisBundle.message((String)"xml.quickfix.remove.attribute.text", (Object[])new Object[]{this.myLocalName});
        if (string == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.myLocalName != null ? this.getName() : this.getFamilyName();
        if (string == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = XmlAnalysisBundle.message((String)"xml.quickfix.remove.attribute.family", (Object[])new Object[0]);
        if (string == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public PriorityAction.Priority getPriority() {
        PriorityAction.Priority priority = this.myLocalName != null ? PriorityAction.Priority.LOW : PriorityAction.Priority.NORMAL;
        if (priority == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(3);
        }
        return priority;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(4);
        }
        if (element == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(5);
        }
        return RemoveAttributeIntentionFix.getAttribute(element, editor) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(6);
        }
        if (element == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(7);
        }
        this.removeAttribute((PsiElement)RemoveAttributeIntentionFix.getAttribute(element, editor), editor);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            RemoveAttributeIntentionFix.$$$reportNull$$$0(9);
        }
        PsiElement e = descriptor.getPsiElement();
        this.removeAttribute(e, null);
    }

    protected void removeAttribute(PsiElement e, Editor editor) {
        XmlAttribute myAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)e, XmlAttribute.class, (boolean)false);
        if (myAttribute == null) {
            return;
        }
        PsiElement next = RemoveAttributeIntentionFix.findNextAttribute(myAttribute);
        myAttribute.delete();
        if (next != null && editor != null) {
            editor.getCaretModel().moveToOffset(next.getTextRange().getStartOffset());
        }
    }

    @Nullable
    private static PsiElement findNextAttribute(XmlAttribute attribute) {
        for (PsiElement nextSibling = attribute.getNextSibling(); nextSibling != null; nextSibling = nextSibling.getNextSibling()) {
            if (!(nextSibling instanceof XmlAttribute)) continue;
            return nextSibling;
        }
        return null;
    }

    private static XmlAttribute getAttribute(PsiElement element, Editor editor) {
        XmlAttribute result = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)element, XmlAttribute.class);
        if (result != null) {
            return result;
        }
        if (element.getTextRange().getStartOffset() == editor.getCaretModel().getOffset()) {
            return (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)PsiTreeUtil.prevLeaf((PsiElement)element), XmlAttribute.class);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 6, 7, 8, 9 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPriority";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/RemoveAttributeIntentionFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 6, 7, 8, 9 -> new IllegalArgumentException(string);
        };
    }
}

