/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntObjectMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NonNls
public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private static final IntObjectMap<Key<?>> allKeys = ContainerUtil.createIntKeyWeakValueMap();
    private final int myIndex;
    private final String myName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key(@NonNls @NotNull String name2) {
        if (name2 == null) {
            Key.$$$reportNull$$$0(0);
        }
        this.myIndex = ourKeysCounter.getAndIncrement();
        this.myName = name2;
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            allKeys.put(this.myIndex, this);
        }
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.myName;
    }

    @NotNull
    public static <T> Key<T> create(@NonNls @NotNull String name2) {
        if (name2 == null) {
            Key.$$$reportNull$$$0(1);
        }
        return new Key<T>(name2);
    }

    @Contract(value="null -> null")
    public T get(@Nullable UserDataHolder holder) {
        return holder == null ? null : (T)holder.getUserData(this);
    }

    @Contract(value="_, !null -> !null")
    public T get(@Nullable UserDataHolder holder, T defaultValue) {
        T t2 = this.get(holder);
        return t2 == null ? defaultValue : t2;
    }

    @NotNull
    public T getRequired(@NotNull UserDataHolder holder) {
        if (holder == null) {
            Key.$$$reportNull$$$0(2);
        }
        Object t2 = Objects.requireNonNull(holder.getUserData(this));
        if (t2 == null) {
            Key.$$$reportNull$$$0(3);
        }
        return t2;
    }

    public boolean isIn(@Nullable UserDataHolder holder) {
        return this.get(holder) != null;
    }

    public void set(@Nullable UserDataHolder holder, @Nullable T value2) {
        if (holder != null) {
            holder.putUserData(this, value2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable(value="can become null if the key has been gc-ed")
    public static <T> @Nullable(value="can become null if the key has been gc-ed") Key<T> getKeyByIndex(int index) {
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            return allKeys.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @Nullable
    public static Key<?> findKeyByName(@NotNull String name2) {
        if (name2 == null) {
            Key.$$$reportNull$$$0(4);
        }
        IntObjectMap<Key<?>> intObjectMap = allKeys;
        synchronized (intObjectMap) {
            for (Key<?> key : allKeys.values()) {
                if (!name2.equals(key.myName)) continue;
                return key;
            }
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/Key";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/Key";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequired";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRequired";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findKeyByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

