/* SPDX-License-Identifier: GPL-2.0-only */
/*
 * Copyright (C) 2024 Intel Corporation
 */

#ifndef __IPU6_PCI_TBL_H__
#define __IPU6_PCI_TBL_H__

#include <linux/pci.h>

#define PCI_DEVICE_ID_INTEL_IPU6		0x9a19
#define PCI_DEVICE_ID_INTEL_IPU6SE		0x4e19
#define PCI_DEVICE_ID_INTEL_IPU6EP_ADLP		0x465d
#define PCI_DEVICE_ID_INTEL_IPU6EP_ADLN		0x462e
#define PCI_DEVICE_ID_INTEL_IPU6EP_RPLP		0xa75d
#define PCI_DEVICE_ID_INTEL_IPU6EP_MTL		0x7d19

static const struct pci_device_id ipu6_pci_tbl[] = {
	{ PCI_VDEVICE(INTEL, PCI_DEVICE_ID_INTEL_IPU6) },
	{ PCI_VDEVICE(INTEL, PCI_DEVICE_ID_INTEL_IPU6SE) },
	{ PCI_VDEVICE(INTEL, PCI_DEVICE_ID_INTEL_IPU6EP_ADLP) },
	{ PCI_VDEVICE(INTEL, PCI_DEVICE_ID_INTEL_IPU6EP_ADLN) },
	{ PCI_VDEVICE(INTEL, PCI_DEVICE_ID_INTEL_IPU6EP_RPLP) },
	{ PCI_VDEVICE(INTEL, PCI_DEVICE_ID_INTEL_IPU6EP_MTL) },
	{ }
};

#endif /* __IPU6_PCI_TBL_H__ */
